function [conds]=generate_onsets(cond,cond_num,trial_num);

% condition generation

interval=cond.interval;
duration=cond.duration;
d_jitter=cond.duration_jitter;
i_jitter=cond.interval_jitter;

onsets=1:interval:(trial_num*interval)*cond_num;
onset_jitter = randn(1,length(onsets))*i_jitter;
onsets=onsets+onset_jitter;
duration_jitter = randn(1,length(onsets))*d_jitter;
durations=duration+duration_jitter;
durations=abs(durations);
onsets=abs(onsets);

if cond.permutate==true;   % to permutate the conditions
    perm=randperm(trial_num*cond_num);
    onsets=onsets(perm);  % random shuffling of the two conditions
    durations=durations(perm);  % random shuffling of the two conditions
end

for i=1:cond_num;
   onsets_cond{i}=onsets(((trial_num*(i-1))+1):trial_num*i);
   durations_cond{i}=durations(((trial_num*(i-1))+1):trial_num*i);
end
conds.onsets=onsets;
conds.durations=durations;
conds.onsets_cond=onsets_cond;
conds.durations_cond=durations_cond;