function [pats]=generate_patttern(pat, cond_num, trial_num );

% paterrn generation

vox_num=pat.voxel_num;
Bsnr=pat.trial_var;
Ssnr=pat.scan_noise;
Vsnr=pat.voxel_var;
Psnr=pat.pattern_var;
true_B=pat.true_beta;

Nt= trial_num;
variance_coherence=0; % if 1 then the trial variance will be correlated across the voxels
noise_coherence=0;
pattern=zeros(vox_num,length(pat.regs{1,1}(1,:)));
tpattern=zeros(vox_num,length(pat.regs{1,1}(1,:)));
for i=1:cond_num;                                             % generate true pattern for each condition
    tB{i}=repmat(true_B{i},vox_num,Nt);
    v_var=randn(vox_num,1)*Vsnr; v_var=repmat(v_var,1,Nt);
    if variance_coherence==1;
       t_var=randn(1,Nt)*Bsnr;   
       t_var=repmat(t_var,vox_num,1);  % trial to trial variability matrix (all voxels should share the same variablity)
    else
       t_var=randn(vox_num,Nt)*Bsnr;    
    end
    
%%% just for test    
%     if pat.myrand==true;
%        if length(pat.myrand2)==trial_num; 
%           t_var=pat.myrand2;
%        else
%            sprintf('pat.myrand2 should have the same length as trial numbers')
%        end
%     end
        
    p_var=randn(vox_num,Nt)*Psnr;                             % pattern to pattern variability- can be think of as different examples for same class in the condition;
    
    tP{i}=tB{i}+ v_var;                                        % the true pattern for each condition 
    B{i}=tB{i}+ v_var + p_var + t_var;                        % this should generate patterns for each condition
    pats.mB_cond{i}=mean(B{i}');                              % recording sample mean for each condition
    Xhf{i}=[pat.regs{i}' ones(size(pat.regs{i}',1),1)];
    for j=1:vox_num;
      Y{i}(j,:)=Xhf{1,i} * [B{i}(j,:)'; 0];                   % generate bold signal for each cond
    end
    pattern=pattern + Y{1,i};  
    
    for j=1:vox_num;
      Y{i}(j,:)=Xhf{1,i} * [tB{i}(j,:)'; 0];                   % generate bold signal for each cond
    end
    tpattern=tpattern + Y{1,i};  
    
    var{i}=t_var;
    
    % summing the activity for all the conds into one pattern
end

if noise_coherence==0;
   scan_noise=randn(size(pattern))*Ssnr;
   y=pattern+scan_noise;                           % adding scanner noise
   
else
   noise_vec=randn(size(pattern,2),1);
   scan_noise=repmat(noise_vec,1,size(pattern,1))';
   y=pattern+(scan_noise*Ssnr);
end
    


pats.tP=tP;                                                   % recording true pattern for each condition for a good reason
pats.pattern=pattern; 
pats.tpattern=tpattern;
pats.bold=y;                                                  % the generating bold activity for all the voxels
pats.tB=B; 
pats.scan_noise=scan_noise;              
pats.var=var;


%% this is for pat estimations

% conv_regs=conv_regs';
% pat.conv_regs=conv_regs;   % should do this for mumford as well
% 
% pat.iXhf=pinv(conv_regs');