function [regs]=generate_regressors(reg, cond_num,trial_num);

% regressor generator

     TR=reg.tr;
     onsets=reg.onsets;
     durations=reg.durations;
         
    durations=durations/TR;  % scalling the onsets and durations according to TR
    onsets=onsets/TR;
    hrf=spm_hrf(TR);
    hrf  = hrf/max(hrf);    % HRF scaled to 1
    Nh   = length(hrf);
    Ni   = [0:(Nh-1)];

    [p ind]=max(onsets);

    total_duration=zeros(1,onsets(ind)+durations(ind)); % estimating the total scan duration
    solid_reg=zeros(length(onsets),length(total_duration));

    Nt=length(onsets);
%     for i=1:Nt;
%         solid_reg(i,ceil(onsets(i)):ceil(onsets(i)+ durations(i)))=1;
%     end

    for i=1:Nt;
        solid_reg(i,ceil(onsets(i)))=1;
    end
    
%     for i=1:Nt;
%         lsa(i,:)=conv(solid_reg(i,:),hrf);
%     end 
 
 % faster than above but is it as accurate?
    for r=1:Nt;   
        ind = find(solid_reg(r,:)); 
        lsa(r,Ni+ind) = hrf;
     end

 
    for i=1:cond_num;
      ereg{i}=lsa( (((trial_num*(i-1))+1):trial_num*i), :);  % separate the regs for each condition
      creg{i}=sum(ereg{i});              % a reg for each condition
    end
    
    
    regs.solid_reg=solid_reg;            % non-convolved reg
    
    % sanity check delete lator
%     regs.sum_solid=sum(solid_reg);
%     regs.sum_conv=conv(regs.sum_solid,hrf);
    % sanity check delete later
    
    regs.combined_reg=sum(lsa);          % all regs combined
    regs.ereg=ereg;
    regs.creg=creg;
    regs.lsa=lsa;                        % a reg for each trial (LS-A)
    
    Ns=length(lsa(1,:));   
    
    % generate LS-S regs
    for i=1:Nt;
        tmp=lsa;
        lss_interest=lsa(i,:);         % taking out the reg of interest
        tmp(i,1:Ns)=0;                 % all other regs excluding reg of interest
        for j=1:cond_num;
            lss_out{j}=tmp( (((trial_num*(j-1))+1):trial_num*j), :);  %summing other regs without the reg of interest
            lss_each_separate{j}=sum(lss_out{j});
        end
            lss_separate_tmp=cat(1,lss_each_separate{:});
            lss_combined_tmp=sum(lss_separate_tmp);
            lss_separate(:,:,i)=[lss_separate_tmp; lss_interest];
            lss_sep_vis{i}=[lss_separate_tmp; lss_interest];     % just for visualization
            if cond_num>1;
              lss_combined(:,:,i)=[lss_combined_tmp; lss_interest];
            end
    end
    lss_sep_vis=cat(1,lss_sep_vis{:});
    regs.lss_sep_vis=lss_sep_vis; % just for visualization
        
    regs.lss_sep=lss_separate;          % mumfords-turner lS-S
    if cond_num>1
      regs.lss_comb=lss_combined;
    end
    
    
    
    
    
    
    
    
    