   %% press Run for a Demo: The script is for simulating BOLD signal for various SOA and noise types:
   
   
     %% global parameters: (change them to compare the GLMS)
     
     
     ns=10*60;            % mumber of the scans (fixed scanner duration)
     soa=3;              % stimulus onset asynchrony
     Tvar=0.2;           % amount of trial-to-trial variability (Note HRF is scaled to 1 ie hrf=hrf/max(hrf); )
     Svar=0.2;           % amount of scan-to-scan variability (Note HRF is scaled to 1 ie hrf=hrf/max(hrf); )
     true_beta=0;        % true beta value
     cond_num=1;         % be aware if you increase the number of conditions, some other parts of the script also needs to be changed otherwise the code will break.
     trial_num=ns/soa;   % number of trials for the fixed scan numbers above 
     
   %% generate condition onsets and durations (gen_cond):
   
     cond.interval=soa;                          % stimulus onset asynchrony (seconds)
     cond.duration=1;                            % stimulus presentation duration (seconds)
     cond.permutate=false;                       % ignore! set this to false if you don't want to intermix conditions
     cond.duration_jitter=0;                     % igonre! jittering
     cond.interval_jitter=0;
     
     [conds]=generate_onsets(cond, cond_num, trial_num); % generate onsets and durations for all conds
     
   %% generate LSA and LSS regressors (gen_reg):
    
     reg.tr=1;                                  % TR - scanner time resolution 
     reg.onsets=conds.onsets;                   % uses the output from the gen_cond function above
     reg.durations=conds.durations;
     
     [regs]=generate_regressors(reg, cond_num, trial_num);  % generate LS-A and LS-S regs
    
   %% generate patterns with various noise types and levels (gen_pat):
     
     pat.voxel_num=1;                           % ignore! number of voxels (changing these parameters requires modification of some other parts in the script as well otherwise the code will break)
     pat.trial_var=Tvar;                        % trial to trial variability (SD)
     pat.scan_noise=Svar;                       % scan noise (SD)
     pat.voxel_var=0;                           % ignore! voxel to voxel variability (SD)
     pat.pattern_var=0;                         % pattern to pattern variability (SD) 
     pat.regs= regs.ereg;                       % using gen_reg output above to generate simulated patterns

%% modifiy below if you want more than one condition
%      for i=1:cond.cond_num; 
        i=1;  
        pat.true_beta{i}=true_beta;  
%      end 
              
     [pats]=generate_pattern(pat, cond_num, trial_num);   % generate simulated pattern with the assigned noise levels above
             
      %% GLM estimation using LSA or LSS or standard GLM
   
     bold=pats.bold;             % the simulated bold activity
     cond_regs=regs.creg;
     lsa_regs=regs.lsa;         %lsa regressor
     lss_regs=regs.lss_sep;     %lss regressor
     vox_num=pat.voxel_num;     %number of voxels
     
     [lsa_betas]=estimate_lsa(bold, lsa_regs, cond_num, trial_num);                    %estimate individual betas for each trial using LSA
     [lss_betas]=estimate_lss(bold, lss_regs, cond_num, trial_num);                    %estimate individual betas for each trial using LSA
     penalty=1;
     [rlsa_betas]=estimate_rlsa(bold, lsa_regs, cond_num, trial_num ,penalty);                    %estimate individual betas for each trial using LSA

     
    %% visualise the differences between the GLM models (please vary the
    %% global parameters: soa, Tvar, Svar to compare the GLMs) 
    
     tb=repmat(true_beta,length(pats.tB{1}),1);
     scale=1;
     figure(1); clf(1); 
     subplot(3,1,1);
     hold on; 
     plot(tb,'g');  ylim([-scale scale]); 
     plot(pats.tB{1},'b');  
     plot(lsa_betas{1},'r'); legend('True Betas','True Betas+Variance','LSA Betas'); title(sprintf('SOA=%ds',soa));
     hold off;
     subplot(3,1,2);
     hold on;
     plot(tb,'g'); ylim([-scale scale]); 
     plot(pats.tB{1},'b'); 
     plot(lss_betas{1},'r'); legend('True Betas','True Betas+Variance','LSS Betas');
     hold off;
     subplot(3,1,3);
     hold on;
     plot(tb,'g'); ylim([-scale scale]); 
     plot(pats.tB{1},'b'); 
     plot(rlsa_betas{1},'r'); legend('True Betas','True Betas+Variance','regularised LSA');
     hold off; 

 

