%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% T.Auer, 2/7/13; tibor.auer@mrc-cbu.cam.ac.uk
%
% Batch for SVC
%
% The program can be run only after SPM Results, which creates SPM, xSPM, 
% and hReg. It requires a text file containing either:
%    - .csv: comma-seperated values (CSV) listing the
%      coordinates in a n x 3 format (one line for one location.
%        E.g.:
%            36,-22,62
%            40,-18,56
%            ...
%
%    - .txt: list of full paths of the masks
%        E.g.:
%            /imaging/ta02/ActionWords/Analysis/ROI/Action/subject/gLeftFinger.hdr
%            /imaging/ta02/ActionWords/Analysis/ROI/Action/subject/gLeftFoot.hdr
%            ...
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Obtain inputs
[fname, fpath] = uigetfile({'*.csv', 'CSV file containig the (list of) coordinates (n x 3)';...
    '*.txt', 'text file containing full paths of the masks'},'List');
if ~fname, return; end

isImage = strcmp(fname(end-2:end),'txt');

if ~isImage
    txyz = csvread(fullfile(fpath,fname));
    for c = 1:size(txyz,1)
        xyz{c} = txyz(c,:)';
    end
    strROI = {'Sphere','Box'};
    [s,v] = listdlg('PromptString','Select ROI:',...
        'SelectionMode','single',...
        'ListString',strROI);
    if ~v, return; end
    ROI = strROI{s}(1);
    D = inputdlg('Size(s): 1 or 3 numbers');
    if isempty(D) || isempty(D{1}), return; end
    if any(isspace(D{1}))
        D = str2mat(D{1});
    else
        D = str2double(D{1});
    end
else
    xyz = {};
    fid = fopen(fullfile(fpath,fname),'r');
    while ~feof(fid)
        xyz{end+1} = fgetl(fid);
    end
    fclose(fid);
    ROI= 'I';
    D = 0;
end

% Performing SVCs
for i = 1:size(xyz,1)
    strROI = {};
    % Run SVC for the given location and save the results
    TabDat(i) = spm_SVC(SPM,xSPM,hReg,ROI,xyz{i},D);
    Title = TabDat(i).tit; Title = [upper(Title(1)) Title(2:end)];
    % Output summary
    fprintf('%s: %d significant cluster\n',Title,size(TabDat(i).dat,1));
    % Save the location in case of significant result
    if size(TabDat(i).dat,1)
        if isImage
            strROI{end+1} = xyz{i};
        else
            strROI{end+1} = mat2str(xyz{i});
        end
    end
end

if isempty(strROI), return; end

% Individual SVCs only for location(s) with significant result
while true
    [s,v] = listdlg('PromptString',{'List of ROI(s) with' 'significant results.' 'Click Cancel to exit'},...
        'SelectionMode','single',...
        'ListString',strROI);
    if ~v, break; end
    if isImage
        xyz = strROI{s};
    else
        xyz = str2num(strROI{s})';
    end
    iTabDat = spm_SVC(SPM,xSPM,hReg,ROI,xyz,D);
end

