% script to loop over analyses to print SPMs
% SPMs are printed in the analysis directory specified under 'subjects'
% This to pass vars to the individual analysis routines
% copy csl_getRes.m and csl_getSPM2.m to directoryofyourchoice

addpath /imaging/yourimagingspace/directoryofyourchoice %CHANGE THIS
spm_defaults;
global defaults
defaults.modality='FMRI';
anadirs = {'McAuley_SPM5'} %  NAME OF ANALYSIS DIRECTORY (or directories) at single subject level  %CHANGE THIS
for  j = 1:size(anadirs,2) 
    ana_dir = anadirs{j}
%--------------------------------------------------------------------
%- Setup the parameters for each subjects        

% get subject numbers, names
%subjroot : root directory
subjroot ='/imaging/jessica/Rowe/aa/'; %NAME OF ROOT DIRECTORY FOR STUDY,  %CHANGE THIS

%SUBJECT DIRECTORIES,  %CHANGE THIS
subjects = {'CBU060666',...
 'CBU060667',...
 'CBU060668',...
 'CBU060670',...
 'CBU060671',...
 'CBU060672',...
 'CBU060675',...
 'CBU060676',...
 'CBU060677',...
 'CBU060678',...
 'CBU060679',...
 'CBU060680',...
'CBU060681',...
'CBU060705',...
'CBU060706',...
'CBU060707',...
'CBU060708',...
'CBU060859',...
'CBU060922',...
'CBU060932',...
'CBU060937',...
'CBU060943',...
'CBU060944',...
'CBU060951',...
'CBU060952',...
'CBU060953',...
'CBU060954',...
'CBU060955',...
'CBU060956',...
'CBU060957',...
'CBU060958',...
'CBU060973',...
'CBU060974',...
};

nsubs = length(subjects);
 
% list of contrasts
% Contrast numbers (from xCon file)
cons = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]; % if you know them already,  %CHANGE THIS
    
%--------------------------------------------------------------------
%- xSPM is a structure for the parameters
% with the threshold set to FDR 0.05 

xSPM = struct( ...
      'swd', '', ...       % full path to SPM.mat file
      'Ic', [], ...        % no of contrast (or contrasts for conjunction)
      'Im', [],...         % no of contrast to mask with. Empty for no masking
      'pm', [],...         % masking contrast uncorrected p
      'Ex', [],...         % whether masking is inclusive or exclusive
      'title', '',...      % if empty results in default contrast title
      'Mcp', 'FDR',...    % Mutiple comp method: FWE|FDR|none
      'u', 0.05,...        % threshold (corrected or uncorrected, as above)
      'k', 0);             % extent threshold
%--------------------------------------------------------------------
%- Loop over the subject and for each subject over the contrasts defined in cons.

for s = 1:length(subjects)
    xSPM.swd = fullfile(subjroot, subjects{s},ana_dir) %analysis directory
	xSPM.spmmat = fullfile(subjroot,subjects{s},ana_dir, 'SPM.mat') % Get SPM path
	 bck_xSPM=xSPM;						 % Back	up xSPM 
	for i = 1:length(cons)	
	   xSPM.Ic=cons(i);					  %Set the current contrast Index	
	   [hReg,xSPM,SPM] = csl_getRes(xSPM);
	   spm_list('List',xSPM,hReg);
       spm_print(fullfile(subjroot,strcat(ana_dir, '.ps')))
	   %spm_print;
	   xSPM= bck_xSPM; 					  % Reset xSPM to default 
	end
end


end


