% script to loop over analyses to print SPMs
% SPMs are printed in the analysis directory specified under 'subjects'
% This to pass vars to the individual analysis routines
spm_defaults;
global defaults

defaults.modality='FMRI';


%--------------------------------------------------------------------
%- xSPM is a structure for the parameters
% with the threshold set to FDR 0.05 

xSPM = struct( ...
      'swd', '', ...       % full path to SPM.mat file
      'Ic', [], ...        % no of contrast (or contrasts for conjunction)
      'Im', [],...         % no of contrast to mask with. Empty for no masking
      'pm', [],...         % masking contrast uncorrected p
      'Ex', [],...         % whether masking is inclusive or exclusive
      'title', '',...      % if empty results in default contrast title
      'Mcp', 'FDR',...    % Mutiple comp method: FWE|FDR|none
      'u', 0.05,...        % threshold (corrected or uncorrected, as above)
      'k', 0);             % extent threshold


%--------------------------------------------------------------------
%- Setup the parameters for each subjects        

% get subject numbers, names
%subjroot : root directory
subjroot ='/imaging/jessica/Rowe/aa/';

subjects = {... %subject _and_ analysis directory where results to be printed reside
     'CBU060474/SPM5_td_dd',...
     'CBU060506/SPM5_td_dd',...
     'CBU060507/SPM5_td_dd',...
     'CBU060508/SPM5_td_dd',...
     'CBU060509/SPM5_td_dd',...
      'CBU060510/SPM5_td_dd',...
      'CBU060511/SPM5_td_dd',...
      'CBU060512/SPM5_td_dd',...
      'CBU060513/SPM5_td_dd',...
      'CBU060514/SPM5_td_dd',...
     'CBU060515/SPM5_td_dd',...
     'CBU060516/SPM5_td_dd',...
     'CBU060517/SPM5_td_dd',...
     'CBU060518/SPM5_td_dd',...
     'CBU060519/SPM5_td_dd',...
      'CBU060520/SPM5_td_dd',...
     'CBU060521/SPM5_td_dd',...
     'CBU060525/SPM5_td_dd',...

};

nsubs = length(subjects);
  
% list of contrasts
% Contrast numbers (from xCon file)
cons = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]; % if you know them already



%--------------------------------------------------------------------
%- Loop over the subject and for each subject over the contrasts defined in cons.

for s = 1:length(subjects)
    xSPM.swd = fullfile(subjroot, subjects{s},'SPM5_td_dd') %analysis directory
	xSPM.spmmat = fullfile(subjroot,subjects{s}, 'SPM.mat'); % Get SPM path
	 bck_xSPM=xSPM;						 % Back	up xSPM 
	for i = 1:length(cons)	
	   xSPM.Ic=cons(i);					  %Set the current contrast Index	
	   [hReg,xSPM,SPM] = csl_getRes(xSPM);
	   spm_list('List',xSPM,hReg);
	   spm_print;
	   xSPM= bck_xSPM; 					  % Reset xSPM to default 
	end
end





