function graphicsHandles()
close all
load('BehaviouralRatings.mat')

% Variables:
% Subj - Subject numbers
% Slow - Matrix of speech rate ratings after listening to slow speech
% Fast - Matrix of speech rate ratings after listening to fast speech
% Time - Seconds after onset of normal speech


% Plot the ratings of Subj 1 after listening to slow speech

hLine = plot(Time, Slow(1,:))

% let's see the properties of the figure object
get(hLine,'Type')
get(hLine)
% Always use a variable to get the handle, do not use the number of the
% handle directly. Example:
% get(172.08) --> error

% What happens here?
figure
hLine_Mult = plot(Time, Slow)

% Create another figure
hSecondFig = figure

% Get the properties of hSecondFig
typeFig = get(hSecondFig,'Type')
get(hSecondFig)

% this is equivalent to get(gcf)

% % Plot the ratings of Subj 1 after listening to fast speech

hLine2 = plot(Time, Fast(1,:))
% Get the properties of the new plot
get(hLine2,'Type')
get(hLine2)

%%
% The hierarchy is: figure --> axes --> line

% Get the first axes (from the first plot)
hFirstAxes = get(hLine,'Parent')
get(hFirstAxes,'Type')
hCurrentAxes = gca

% Get the first figure
hFirstFig = get(hFirstAxes,'Parent')
get(hFirstFig,'Type')

% Go back to plot something on the second figure
figure(hSecondFig)
plot(Fast(1,:),'r')

% Close the second figure and see what happens
close(hSecondFig)

% The handle still exists (it's a variable that we defined and we didn't delete
% it)
hSecondFig

% The object does not exist, the linkage between the handle and the object
% disappeared.
% get(hSecondFig) % --> error

% Use 'set' to see the options of the properties
set(hFirstAxes)

% % Change the title of the figure window
% get(hFirstFig)
% set(hFirstFig,'Name','First Figure')
% set(hFirstFig,'NumberTitle','off')

% Add grid to the axes
set(hFirstAxes,'XGrid','on')
set(hFirstAxes,'YGrid','on')

% Remove grid
set(hFirstAxes,'XGrid','off')
set(hFirstAxes,'YGrid','off')
% Or: grid off

% Change the color of the line
set(hLine,'Color','r')

% Change the axis of the axes object
set(hFirstAxes,'XLim',[0 10])
set(hFirstAxes,'YLim',[-100 100])

% Change them back
set(hFirstAxes,'XLim',[0 20])
set(hFirstAxes,'YLim',[-60 30])

% We can create many figures, 'remember' what is in each figure, and change
% the figures that we want

close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% What about subplot?

% Create a new figure
hSecondFig = figure;

% Subplot and plot
hSub1 = subplot(2,1,1)
get(hSecondFig,'Children')
get(hSub1,'Children')
get(hSub1,'Parent')
hPlot = plot(hSub1,Time,mean(Slow))
get(hSub1,'Children')
hSub2 = subplot(2,1,2)
hPlot2 = plot(hSub2,Time,mean(Fast),'m--')
get(hPlot2,'Children') 

% some more properties you might want to change

forest_green_RGB = [34 139 34]/255;
set(hPlot2                           , ...
  'LineWidth'       , 2           , ...
  'Marker'          , 's'         , ...
  'MarkerSize'      , 6           , ...
  'MarkerEdgeColor' , forest_green_RGB , ...
  'MarkerFaceColor' , [143 12 0]/255 );

%%
% x-label, y-label, title  - are objects themselves
hXlabel = get(hSub1,'XLabel');
set(hXlabel,'String','time (seconds)')

hTitle = get(hSub1,'Title');
set(hTitle,'String','Speech Rate Ratings: slow') % check out FontName

hXlabel = get(hSub2,'XLabel');
set(hXlabel,'String','time (seconds)')

hTitle = get(hSub2,'Title');
set(hTitle,'String','Speech Rate Ratings: fast')

% Changing axis properties
set(gca, ...
  'TickDir'     , 'out'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'on'      , ...
  'YMinorTick'  , 'on'      , ...
  'YGrid'       , 'on'      , ...
  'XColor'      , [.3 .3 .3], ...
  'YColor'      , [.3 .3 .3], ...
  'YTick'       , 4:0.1:5, ...
  'LineWidth'   , 1         );


%%

%% Saving figures

% Save the figure - as '.fig'
fileName = 'BehaviouralPlot';
saveas(hSecondFig, fileName);
% OR: saveas(hSecondFigure, fileName,'fig')
% OR: saveas(hSecondFigure, 'BehaviouralPlot','fig')

% Save the figure - as '.jpg'
saveas(hSecondFig, fileName,'jpg');

%% Save a higher quality figure

set(hSecondFig,'PaperUnits','inches');
set(hSecondFig,'PaperSize', [8 8]);
set(hSecondFig,'PaperPosition',[0.5 0.5 7 7]);
set(hSecondFig,'PaperPositionMode','Manual');

print(hSecondFig, '-dpdf', '-r150', [fileName '.pdf']); % for other options see help print

close(hSecondFig);

