
% Frequencies
f1=0.01;
f2=0.03;

% Size of square image
sz=1800;

% prepare figure
figure(10); clf;

%% Original with Loops
tic % Start timing (only use this clock for non-time critical applications)
clear z
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end;
end;
% Draw figure
figure(10); clf; imagesc(z)
fprintf('\nLoops and no preallocation: Elapsed time is %g seconds',toc)

%% still with loops, but now preallocating z
tic % Start timing (only use this clock for non-time critical applications)
clear z
z=zeros(sz,sz);
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end;
end;
% Draw figure
figure(10); clf; imagesc(z)
fprintf('\nLoops, but now with preallocation: Elapsed time is %g seconds',toc)

%% Vectorize to avoid loop
tic
clear z
% Make row*f1+col*f2
z1=repmat((1:sz)*f1,[sz 1])'+repmat((1:sz)*f2,[sz 1]);
z=sin(z1);
% Draw figure
figure(11); clf; imagesc(z);
fprintf('\nVectorized (as rows): Elapsed time is %g seconds',toc)

%% Finally, it's faster to operate on column vectors than row vectors!
tic
clear z
% Make row*f1+col*f2
z1=repmat((1:sz)'*f1,[1 sz])+repmat((1:sz)'*f2,[1 sz])';
z=sin(z1);
% Draw figure
figure(10); clf; imagesc(z);
fprintf('\nVectorized (as columns): Elapsed time is %g seconds',toc)

fprintf('\nDone.\n')
    