function vector=problematic_script_now_as_function(vectorlength)

tic; % matlab can tell you that it assumes this is intended as a function...

if ~nargin
    vectorlength=3; %... and this is intended as a variable
end

for position=1:vectorlength
    vector(position)=randi(9,1);
end
%%% Here we could have also avoided the problem by defining the whole 
%%% vector rather than looping through elements:
%   vector=randi(9,1,vectorlength);
%%% although occasionally this might not be possible.

vector(end+1)=min(vector(1:vectorlength));
fprintf('\nThe last entry in the following vector is the smallest of the preceding %g:',vectorlength)

fprintf('\nTook %g s',toc)

return