function vectorization_example()

% Frequencies
f1=0.01;
f2=0.03;

% Size of square image
sz=1500;

% prepare figure
figure(10); clf;

%% Original with Loops
tic % Start timing (only use this clock for non-time critical applications)
clear z
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end;
end;
fprintf('\nLoops, but no preallocation: \tElapsed time is %g seconds',toc)
% Draw figure
figure(10); clf; imagesc(z)

%% still with loops, but now preallocating z
tic % Start timing (only use this clock for non-time critical applications)
clear z
z=zeros(sz,sz);
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end;
end;
fprintf('\nLoops, now with preallocation: \tElapsed time is %g seconds',toc)
% Draw figure
%figure(10); clf; imagesc(z)

%% Vectorize to avoid loop
tic
clear z
% Make row*f1+col*f2
[x, y]=ndgrid(1:sz);
z=sin(x*f1 + y*f2);
fprintf('\nVectorized to avoid loops: \tElapsed time is %g seconds',toc)
% Draw figure
%figure(10); clf; imagesc(z);


%% Finally, it can be faster to operate on column vectors than row vectors!
X=repmat(z,20,20);

%% sum along rows...
tic; 
sum(X,2);
fprintf('\nSumming matrix along rows: \tMean elapsed time is %g seconds',toc)

%% sum down columns... 
tic; 
sum(X,1);
fprintf('\nSumming matrix down columns: \tMean elapsed time is %g seconds',toc)


%%
fprintf('\nDone.\n')
return