function J_vectorization_example2()
% Looping can be especially slow when it involves repeated file access

% make a random connectivity matrix

N=500;
connectmat=rand(N)+5*toeplitz(tanh(linspace(0,2*pi,N))); % make an arbitrary symmetric matrix
figure(10); clf; imagesc(connectmat); axis image; colormap jet; colorbar
drawnow

% define output file
fname=fullfile(fileparts(mfilename('fullpath')),'temp1.txt');

%% write it the slow way, one cell at a time
fprintf('\nWriting %g node connectivity matrix to Pajek format, one cell at a time',N);
tic
fid = fopen(fname, 'w');

%%% VERTICES
fprintf(fid, '*vertices %6i \r', N);
for i = 1:N
    fprintf(fid, '%6i "%6i" \r', [i i]);
end

%%% EDGES
fprintf(fid, '*edges \r');
for i = 1:N
    for j = 1:N
        if connectmat(i,j) ~= 0
            fprintf(fid, '%6i %6i %6f \r', [i j connectmat(i,j)]);
        end
    end
    if ~mod(i,50), fprintf('.'); end
end

fclose(fid);
fprintf(' took %.2f seconds)',toc)

%% write it a faster way
fprintf('\nWriting %g node connectivity matrix to Pajek format, all cells at once:',N);
tic
pairs=[kron(1:N,ones(1,N)); kron(ones(1,N),1:N)]; % list all coordinates
pairs=pairs(:,diff(pairs)>0); % ignore repeated coordinates (because matrix is symmetrical);
% (may want to ignore other pairs too -e.g. those with sub-threshold connection strength)
weights=connectmat(sub2ind(size(connectmat),pairs(1,:),pairs(2,:))); % list all connection weights

fid=fopen(fname,'w');
%%% VERTICES
fprintf(fid,'*vertices %i', N);
fprintf(fid,'\n%i "%04i" ',repmat((1:N),2,1));

%%% EDGES
fprintf(fid,'\n*edges ');
fprintf(fid,'\n%i %i %.7f',[pairs;weights]);

fclose(fid);
fprintf(' took %.2f seconds',toc)
    
%%
return

