
% Script to present Intro to Matlab
%  Hit [Enter] to advance slides
%
% by Jason Taylor (hacky!) 21 Nov 2011
%

%% Set up:
talkdir   = '/imaging/jt03/demo/presentation';
scriptdir = '/imaging/jt03/demo/scripts';

addpath(talkdir);
addpath(scriptdir);

% Options:
titlefont = 24;
textfont  = 18;
gap       = 6;
figpos    = [.15 .15 .8 .8];

% Figure:
tfig = figure('color',[.5 .5 .5],...
    'WindowStyle','normal',...
    'Units','normalized',...
    'ToolBar','none',...
    'position',figpos);


%% TITLE SLIDE (load and show tiff file):
im = imread('intro_slide.png','backgroundcolor',[1 1 1]);
warning('off');
imshow(im);
warning('on');
ax=gca; set(ax,'position',[0 0 1 1]);
set(tfig,'position',figpos);

tmp=input('Hit [ENTER] to advance slides');
figure(tfig)


%% OUTLINE SLIDE
clf;
set(tfig,'color','w');

% Image:
img=imread('matlab_logo.png','BackgroundColor',[1 1 1]);
warning('off');
imshow(img);
warning('on');
set(tfig,'position',figpos);
imax=gca;
axis square off;
set(imax,'position',[.05 .8 .15 .15]);
set(imax,'HandleVisibility','off');

% Text:
ax=axes; set(ax,'xlim',[-10 110],'ylim',[-10 110],'position',[0 0 1 1]);
axis square off

ttl = 'Outline';
txt = {
    {'- Why Matlab?'}
	{'- A Brief (Interactive) Introduction to Matlab'
     '  -> Starting Matlab'
     '  -> Path'
     '  -> Workspace'
     '  -> Numeric Variables'
     '  -> Maths/Logic'
     '  -> Strings, Cells, Structures'
     '  -> Loops'
    }
    {'- Scripts and Functions'
     '  -> An Example Script'
     '  -> An Example Function'
    }
    {'- HELP?! (where to get it)'}
    {'* NOTE: All of this is available in: /imaging/jt03/demo *'}
   };


% Print it:

% - Title:
x=50;y=100;
text(x,y,ttl,'tag','title','horizontalalign','center','fontsize',titlefont);
tmp=input('Hit [ENTER] to advance slides');
figure(tfig);

% - Text:
x=0;
for i=1:length(txt)
    y=y-gap;
    for j=1:length(txt{i})
        y=y-(0.66*gap);
        text(x,y,txt{i}{j},'tag','level2','horizontalalign','left','fontsize',textfont);
    end
    tmp=input('Hit [ENTER] to advance slides'); 
    figure(tfig);
end



%% Next slide: WHY MATLAB (1)
clf;
set(tfig,'color','w');

% Image:
img=imread('command_prompt.png','BackgroundColor',[1 1 1]);
warning('off');
imshow(img);
warning('on');
set(tfig,'position',figpos);
imax=gca;
axis square off;
set(imax,'position',[.05 .8 .15 .15]);
set(imax,'HandleVisibility','off');

% Text:
ax=axes; set(ax,'xlim',[-10 110],'ylim',[-10 110],'position',[0 0 1 1]);
axis square off

ttl = 'Why Matlab?';
subttl = '...or any other command-line program';
txt = {
    {'- Leave data in original format'
     '- Retain a complete record of all processing'
     '- Hard work for first subject, easy sailing for the rest'
     '- Easily modify analysis pipeline and re-run analyses'
    };
    {'Alternatives to Matlab:'
     '- Octave (free!) ... matlab clone'
     '- S-Plus (not free) or R (free!) ... stats'
     '- Yes, you can script Excel (Visual Basic) and SPSS'
     '   (syntax) too, but these are less flexible/powerful'
    }
   };


% Print it:

% - Title:
x=50;y=100;
text(x,y,ttl,'tag','title','horizontalalign','center','fontsize',titlefont);
y=y-gap;
text(x,y,subttl,'tag','subtitle','horizontalalign','center','fontsize',textfont);
tmp=input('Hit [ENTER] to advance slides');
figure(tfig);

% - Text:
x=0;
for i=1:length(txt)
    y=y-gap;
    for j=1:length(txt{i})
        y=y-gap;
        text(x,y,txt{i}{j},'tag','level2','horizontalalign','left','fontsize',textfont);
    end
    tmp=input('Hit [ENTER] to advance slides'); 
    figure(tfig);
end
set(imax,'HandleVisibility','on');
figure(tfig);


%% Next slide: WHY MATLAB (2)
clf;
set(tfig,'color','w');

% Image:
img=imread('matlab_logo.png','BackgroundColor',[1 1 1]);
warning('off');
imshow(img);
warning('on');
set(tfig,'position',figpos);
imax=gca;
axis square off;
set(imax,'position',[.05 .8 .15 .15]);
set(imax,'HandleVisibility','off');

% Text:
ax=axes; set(ax,'xlim',[-10 110],'ylim',[-10 110],'position',[0 0 1 1]);
axis square off

ttl = 'Why Matlab?';
subttl = '... specifically';
txt = {
    {'Versatility:'
     ' - Statistics'
     ' - Image Processing'
     ' - Signal Processing'
     ' - 3D Visualisation'
     ' - Custom (see http://www.mathworks.com/matlabcentral/fileexchange/ )'
    };
    {'Neuroimaging (MRI, fMRI, DTI, M/EEG,...)'
     ' - SPM'
     ' - GIFT / EEGIFT'
     ' - EEGLAB / FMRLAB'
     ' - FieldTrip'
     ' - etc.'
    }
   {'Debugging in the Editor'}
   };


% Print it:

% - Title:
x=50;y=100;
text(x,y,ttl,'tag','title','horizontalalign','center','fontsize',titlefont);
y=y-gap;
text(x,y,subttl,'tag','subtitle','horizontalalign','center','fontsize',textfont);
tmp=input('Hit [ENTER] to advance slides');
figure(tfig);

% - Text:
x=0;
for i=1:length(txt)
    y=y-gap;
    for j=1:length(txt{i})
        y=y-gap;
        text(x,y,txt{i}{j},'tag','level2','horizontalalign','left','fontsize',textfont);
    end
    tmp=input('Hit [ENTER] to advance slides'); 
    figure(tfig);
end


%% (GO TO DEMO):
clf;
set(tfig,'color','w');

ax=axes; set(ax,'position',[0 0 1 1]);
axis square off
set(tfig,'position',figpos);
text(.5,.60,'Go to demo (brief intro to matlab)','FontSize',titlefont,'HorizontalAlign','center');
text(.3,.50,'File will open automatically in 5 seconds','FontSize',textfont,'HorizontalAlign','left');
text(.3,.45,' and you will be able to type in the Command Window.','FontSize',textfont,'HorizontalAlign','left');
text(.3,.35,'To return to the presentation,','FontSize',textfont,'HorizontalAlign','left');
text(.3,.30,'  type ''return'' and hit [ENTER]','FontSize',textfont,'HorizontalAlign','left');
pause(5)
edit brief_intro_to_matlab
keyboard
cd(talkdir);
figure(tfig);


%% Next slide: SCRIPTS/FUNCTIONS (1)
clf;
try 
    set(tfig,'color','w');
catch
    % Figure:
    fig = figure('color',[1 1 1],...
        'WindowStyle','normal',...
        'Units','normalized',...
        'ToolBar','none',...
        'position',figpos);
end

% Image:
img=imread('scroll.jpg');
warning('off');
imshow(img);
warning('on');
set(tfig,'position',figpos);
imax=gca;
axis square off;
set(imax,'position',[.05 .8 .15 .15]);
xpos = diff(get(imax,'xlim'))/2;
ypos = diff(get(imax,'ylim'))/2;
text(xpos,ypos,'f(x)','fontsize',22,'fontweight','bold','horizontalalign','center');
set(imax,'HandleVisibility','off');

% Text:
ax=axes; set(ax,'xlim',[-10 110],'ylim',[-10 110],'position',[0 0 1 1]);
axis square off

ttl = 'Functions & (Batch) Scripts';
txt = {
    {'Functions:'
     ' - General (usually apply to any data, project)'
     ' - Run as command'
     ' - Variables do not stay in workspace'
     '   (except input/output args, debugging environment)'
     ' - Get help by typing help <function>'
    };
    {'Scripts:'
     ' - ''Hack and Run'' (customise to your data, project)'
     ' - Run as command or copy/paste (<F9> line-by-line)'
     ' - Variables stay in workspace'
    }
    {'Both are text files, which you can edit in Matlab''s Editor'
     ' or your favourite text editor (emacs, nedit, wordpad,...)'
     ' NOTE: these vary in terms of debugging friendliness!'
     }
   };


% Print it:

% - Title:
x=50;y=100;
text(x,y,ttl,'tag','title','horizontalalign','center','fontsize',titlefont);
tmp=input('Hit [ENTER] to advance slides');
figure(tfig);

% - Text:
x=0;
for i=1:length(txt)
    y=y-gap;
    for j=1:length(txt{i})
        y=y-gap;
        text(x,y,txt{i}{j},'tag','level2','horizontalalign','left','fontsize',textfont);
    end
    tmp=input('Hit [ENTER] to advance slides'); 
    figure(tfig);
end



%% (GO TO DEMO):
clf;
set(tfig,'color','w');

ax=axes; set(ax,'position',[0 0 1 1]);
axis square off
set(tfig,'position',figpos);
text(.5,.60,'Go to demo (demo script cell by cell)','FontSize',titlefont,'HorizontalAlign','center');
text(.3,.50,'File will open automatically in 5 seconds and','FontSize',textfont,'HorizontalAlign','left');
text(.3,.45,' you will be able to type in the Command Window.','FontSize',textfont,'HorizontalAlign','left');
text(.3,.35,'To return to the presentation,','FontSize',textfont,'HorizontalAlign','left');
text(.3,.30,'  type ''return'' and hit [ENTER]','FontSize',textfont,'HorizontalAlign','left');
pause(2)
edit demo_script_cell_by_cell
keyboard
cd(talkdir);
figure(tfig);


%% Next slide: HELP
clf;
try 
    set(tfig,'color','w');
catch
    % Figure:
    fig = figure('color',[1 1 1],...
        'WindowStyle','normal',...
        'Units','normalized',...
        'ToolBar','none',...
        'position',figpos);
end

% Image:
img=imread('scroll.jpg');
warning('off');
imshow(img);
warning('on');
set(tfig,'position',figpos);
imax=gca;
axis square off;
set(imax,'position',[.05 .8 .15 .15]);
xpos = diff(get(imax,'xlim'))/2;
ypos = diff(get(imax,'ylim'))/2;
text(xpos,ypos,'f(x)','fontsize',22,'fontweight','bold','horizontalalign','center');
set(imax,'HandleVisibility','off');

% Text:
ax=axes; set(ax,'xlim',[-10 110],'ylim',[-10 110],'position',[0 0 1 1]);
axis square off

ttl = 'Where to find HELP';
txt = {{'Obviously:'
	    ' help [<funcname>]'
       }
       {'For pretty, hypertext, browser-based help:'
        ' doc [<funcname>]'
       }
       {'Look at the function!'
        ' type <funcname>'
        ' edit <funcname>'
        }
        {'Online: Matlab Central'
         ' http://www.mathworks.com/matlabcentral/'
         ' http://www.mathworks.com/matlabcentral/fileexchange/'
        }
        {'On the imaging wiki:'
         ' http://imaging.mrc-cbu.cam.ac.uk/imaging/LearningMatlab'
         ' Email lists (e.g., imagers+, imagerstech)'
         }
   };


% Print it:

% - Title:
x=50;y=100;
text(x,y,ttl,'tag','title','horizontalalign','center','fontsize',titlefont);
tmp=input('Hit [ENTER] to advance slides');
figure(tfig);

% - Text:
x=0;
for i=1:length(txt)
    y=y-gap;
    for j=1:length(txt{i})
        y=y-gap;
        text(x,y,txt{i}{j},'tag','level2','horizontalalign','left','fontsize',textfont);
    end
    tmp=input('Hit [ENTER] to advance slides'); 
    figure(tfig);
end


%% THE END:
clf;
set(tfig,'color','w');

ax=axes; set(ax,'position',[0 0 1 1]);
axis square off
set(tfig,'position',figpos);
text(.5,.60,'THE END!','FontSize',titlefont,'HorizontalAlign','center');
text(.3,.50,'Thanks for your attention','FontSize',textfont,'HorizontalAlign','center');
text(.3,.35,'Hit [ENTER] to quit','FontSize',textfont,'HorizontalAlign','center');

tmp=input('Hit [ENTER] to QUIT');


%% End!

close(tfig)
fprintf('\n++ done! ++\n\n');


