
%% Here's some extra stuff you can try...
%
% These commands assume the RT data variables are still in the workspace 
%  (i.e., you have run demo_script_*).
%

%% T-test:

[H,P,CI,STATS] = ttest(mrt(:,1),mrt(:,2),.05,'both');

%--Report results:
if P<.05
    fprintf('\n\nHooray :) Significant result: ');
else
    fprintf('\n\nBooooo :( Non-significant result: ');
end
fprintf('t(%d)=%.3f, p=%.3f\n\n',STATS.df,STATS.tstat,P);


%% Histogram (one subject):

figure; hist(rt,12)

% Better yet, separately for Words and Nonwords:

figure; hist([subjdata(subjdata(:,2)==1,3) subjdata(subjdata(:,2)==2,3)],20); 

%--formatting, titles, labels:
colormap([0 0 1; 1 0 0]);
legend('Word','Nonword');
xlabel('RT');
ylabel('Frequency (Ntrials)');
title(sprintf('RT Frequency Histogram (%s)',subj));


%% Scatter plot:

figure; plot(mrt(:,1),mrt(:,2),'bo')

%--formatting, titles, labels:
xlabel('Word RT');
ylabel('Nonword RT');
title('Scatter Plot of Word and Nonword RTs');

%--add least-squares fit line:
hold on;
lsline;

%--add correlation to plot:
r=corr(mrt(:,1),mrt(:,2));
xlim=get(gca,'xlim');
ylim=get(gca,'ylim');
text(xlim(1)+10,ylim(2)-10,sprintf('r = %.2f',r));


