% File name: StudentsGrades.m
% Introduction to Matlab workshop
% Yaara Erez
% MRC Cognition and Brain Sciences Unit
% November 2015

% Creating the data vector = grades of students in 2 courses
gradesData = randn(2,50) *8 + 70;

% max grade in each course
maxGrades = max(gradesData);

% Is this what we want?

% What we really want is:
maxGrades = max(gradesData, [], 2);

% Mean of course 1
meanThresh = 72;
if (mean(gradesData(1,:)) > meanThresh)
    isMeanThresh = 1;
else
    isMeanThresh = 0;
end

% isMeanThresh1 = mean(gradesData(1,:)) > meanThresh;

% Number of students in course 2 that got a grade larger than ...
gradeThresh = 75;
nStudnets = size(gradesData,2); % Number of students
countGradeLarger = 0;
for ii = 1 : nStudnets
    if gradesData(2,ii) > gradeThresh
        countGradeLarger = countGradeLarger + 1;
    end
end

% Number of students in course 1 that got a grade between ... and ...
gradeThreshUp = 75;
gradeThreshDown = 65;
countGradeBet = 0; % Between
for ii = 1 : nStudnets
    currGrade = gradesData(1,ii); % current grade
    if currGrade > gradeThreshDown && currGrade < gradeThreshUp
        countGradeBet = countGradeBet + 1;
    end
end

% Mean of students in course 1 that got a grade between ... and ...
gradeDataBet = zeros(1, countGradeBet);
gradeBetInds = zeros(1, countGradeBet);
counter = 0;
for ii = 1 : nStudnets
    currGrade = gradesData(1,ii);
    if currGrade > gradeThreshDown && currGrade < gradeThreshUp
        counter = counter + 1;
        gradeDataBet(counter) = currGrade;
        gradeBetInds(counter) = ii;
    end
end
meanGradesBet = mean(gradeDataBet);
% OR:
meanGradesBet2 = mean(gradesData(1,gradeBetInds));

% Of course there are a few ways to do anything.
% Sometimes one way is better than the others.
% Sometimes a few ways are equally good enough.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% At home:
% What does the following line do?
x = mean(gradesData(1,gradesData(1,:)>gradeThreshDown & gradesData(1,:)<gradeThreshUp));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Compute SEM for course 1
dataCourse1 = gradesData(1,:);
nStudents = size(dataCourse1,1);
mean1 = mean(dataCourse1);
sem1 = std(dataCourse1)/sqrt(nStudents);

% t-test
meanGrade = 67;
[h0 p_val] = ttest(dataCourse1,meanGrade,0.05,'right');
% Display h0 and p_val in command line
h0
p_val

% You can run this again with using only 5 students (instead of 50) and see
% what ho would be.


