
% Frequencies
f1=0.01;
f2=0.03;

% Size of square image
sz=1800;

% prepare figure
figure(10); clf;

%% Original with Loops
tic % Start timing (only use this clock for non-time critical applications)
clear z
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end;
end;
% Draw figure
figure(10); clf; imagesc(z)
fprintf('\nLoops and no preallocation: Elapsed time is %g seconds',toc)

%% still with loops, but now preallocating z
tic % Start timing (only use this clock for non-time critical applications)
clear z
z=zeros(sz,sz);
for row=1:sz
    for col=1:sz
        z(row,col)=sin(row*f1+col*f2);
    end;
end;
% Draw figure
figure(10); clf; imagesc(z)
fprintf('\nLoops, but now with preallocation: Elapsed time is %g seconds',toc)

%% Vectorize to avoid loop
tic
clear z
% Make row*f1+col*f2
z1=repmat((1:sz)*f1,[sz 1])'+repmat((1:sz)*f2,[sz 1]);
z=sin(z1);
% Draw figure
figure(10); clf; imagesc(z);
fprintf('\nVectorized (as rows): Elapsed time is %g seconds',toc)

%% Finally, it can be faster to operate on column vectors than row vectors!
X=rand(10000);

%% first sum down columns... 
tic; 
sum(X,1);
fprintf('\nSumming down columns: Mean elapsed time is %g seconds',toc)

%% then sum along rows...
tic; 
sum(X,2);
fprintf('\nSumming along rows: Mean elapsed time is %g seconds',toc)

%%
fprintf('\nDone.\n')
    