clear S
DIR = '/imaging/ta02/ActionWords/LD/aamod_firstlevel_contrasts_00001';
[junk, uname] = system('whoami'); uname = uname(1:end-1);
S.outdir = ['/imaging/' uname '/Workshop/LD_PsT'];

% Order: Easy_WORD (4), Easy_NONWORD (3), Hard_WORD (8), Hard_NONWORD (7)
d = dir(fullfile(DIR,'CBU*'));
for i = 1:numel(d)
    fcons = spm_select('FPListRec',fullfile(DIR,d(i).name),'con_000.\.img');   
    S.imgfiles{1}{i} = fcons([8 7],:);
end

S.contrasts{1}.name = 'Word';
S.contrasts{1}.type = 'T';
S.contrasts{1}.c = [1 0];

S.contrasts{2}.name = 'NonWord';
S.contrasts{2}.type = 'T';
S.contrasts{2}.c = [0 1];

S.contrasts{3}.name = 'Stim';
S.contrasts{3}.type = 'T';
S.contrasts{3}.c = [1 1];

S.contrasts{4}.name = 'Word > NonWord';
S.contrasts{4}.type = 'T';
S.contrasts{4}.c = [1 -1];

S.contrasts{5}.name = 'NonWord > Word';
S.contrasts{5}.type = 'T';
S.contrasts{5}.c = [-1 1];

% contrasts   - cell array of contrast structures, with fields c
%                  (matrix), type ('F' or 'T') and name (optional)
spm('Defaults','FMRI');
batch_spm_anova(S);



