clear S
DIR = '/imaging/ta02/ActionWords/LD/aamod_firstlevel_contrasts_00001';
[junk, uname] = system('whoami'); uname = uname(1:end-1);
S.outdir = ['/imaging/' uname '/Workshop/LD_TsT_Cov'];

% Order: Easy_WORD (4), Easy_NONWORD (3), Hard_WORD (8), Hard_NONWORD (7)
d = dir(fullfile(DIR,'CBU*'));
males = [2 5 6 7 10 12 17]; im = 0;
females = [1 3 4 8 9 11 13 14 15 16 18 19]; ifm = 0;
for i = 1:numel(d)
    fcons = spm_select('FPListRec',fullfile(DIR,d(i).name),'con_000.\.img');   
    if ~isempty(find(i==males,1))
        im = im + 1;
        S.imgfiles{1}{im} = fcons([7],:);
    elseif ~isempty(find(i==females,1))
        ifm = ifm + 1;
        S.imgfiles{2}{ifm} = fcons([7],:);
    end
end

load('behav.mat');
S.user_regs{1} = [behav(males,2).RT]'-mean([behav(males,2).RT]);
S.user_regs{2} = [behav(females,2).RT]'-mean([behav(females,2).RT]);

S.contrasts{1}.name = 'Task G1';
S.contrasts{1}.type = 'T';
S.contrasts{1}.c = [1 0 0 0];

S.contrasts{2}.name = 'Task G2';
S.contrasts{2}.type = 'T';
S.contrasts{2}.c = [0 1 0 0];

S.contrasts{3}.name = 'Task';
S.contrasts{3}.type = 'T';
S.contrasts{3}.c = [1 1 0 0];

S.contrasts{4}.name = 'Task G1>G2';
S.contrasts{4}.type = 'T';
S.contrasts{4}.c = [1 -1 0 0];

S.contrasts{5}.name = 'RT G1';
S.contrasts{5}.type = 'T';
S.contrasts{5}.c = [0 0 1 0];

S.contrasts{6}.name = 'RT G2';
S.contrasts{6}.type = 'T';
S.contrasts{6}.c = [0 0 0 1];

S.contrasts{7}.name = 'RT';
S.contrasts{7}.type = 'T';
S.contrasts{7}.c = [0 0 1 1];

S.contrasts{8}.name = 'RT G1>G2';
S.contrasts{8}.type = 'T';
S.contrasts{8}.c = [0 0 1 -1];

% contrasts   - cell array of contrast structures, with fields c
%                  (matrix), type ('F' or 'T') and name (optional)
spm('Defaults','FMRI');
batch_spm_anova(S);



