% examples of different fMRI designs - inputs for practical_efficiency.m
%
% Things to try:
% * Below we simulate a 5 minute run (150 vols at tr=2s). What happens if the
% run is longer?
% * What if we put the trials on every volume rather than on every other volume?
% * Would these designs still be efficient for a different contrast, like [1 0]?
% * Suppose we need a rapid event-related design, but want to get even closer to
% the block design's efficiency. How do we do that?
% * What if we need to distinguish conditions which alternate, e.g. a cue and
% recall phase in a memory experiment. How should we change the trial timings to
% make this design more efficient?
%
% 20180207 J Carlin, MRC CBU
nvol = 150;

% % present trial every other volume, but leave the last 10 vols for HRF to run
% out
onsets = 1:2:(nvol-10);

% % event-related - alternating sequence. Horrendously inefficient
fprintf('rapid event-related design, fixed sequence\n')
conind = 2-mod(1:numel(onsets),2);
practical_efficiency(onsets,conind,[1 -1],nvol);
fprintf('press any key to continue...\n');
pause;

% % event-related - random sequence. Reasonably efficient.
fprintf('rapid event-related design, random sequence\n')
conind = ceil(2*rand(1,numel(onsets)));
practical_efficiency(onsets,conind,[1 -1],nvol);
fprintf('press any key to continue...\n');
pause;

% % blocked presentation - 4 trials per block. More efficient.
fprintf('block design\n')
conind = (mod(0:2:(nvol-1),16) >= 8) + 1;
conind = conind(1:numel(onsets));
practical_efficiency(onsets,conind,[1 -1],nvol);
fprintf('press any key to continue...\n');
pause;

% too slow block design - effect gets lost in high-pass filter
fprintf('slow block design\n')
conind = floor((1:2:nvol) / (nvol/2)) + 1;
conind = conind(1:numel(onsets));
practical_efficiency(onsets,conind,[1 -1],nvol);
