% demo of orthogonalisation of regressors.
%
% test_orthogonalisation
function test_orthogonalisation

% similarly collinear data and regressors
source = rand(200,3) + rand;
x1 = source * [.5 .25 .25]';
x2 = source * [.25 .5 .25]';
y = source * [.25 .25 .5]';

% fitting x1 on its own
x1_alone = [x1 ones(200,1)] \ y
% adding x2 reduces x1 estimate
x1_x2 = [x1 x2 ones(200,1)] \ y

% manual orthogonalisation (X2 wrt X1)
x2_orth = x2 - (x1 * (x1 \ x2));

% now x1 should be the same as in the original model, while x2 remains unchanged
x1_x2_orth = [x1 x2_orth ones(200,1)] \ y

% spm orthogonalisation (serial - second wrt to first etc)
spm_x1_x2_orth = [spm_orth([x1 x2]) ones(200,1)] \ y

% what if we just mean correct x2? Well, that basically orthogonalises x2 with
% regard to the constant term - so any mean effect gets assigned to the
% constant. Does not change x2 itself.
x1_x2_demean = [x1 x2-mean(x2) ones(200,1)] \ y
