start_spm; 
clear S
DIR = '/imaging/jc01/Workshop_ta/Analysis/Results/LD/aamod_firstlevel_contrasts_00001';
uname = getenv('USER');
S.outdir = ['/imaging/' uname '/Workshop/LD_ANOVAmixed3'];

% Order: Easy_WORD (4), Easy_NONWORD (3), Hard_WORD (8), Hard_NONWORD (7)
d = dir(fullfile(DIR,'CBU*'));
males = [2 5 6 7 10 12 17]; im = 0;
females = [1 3 4 8 9 11 13 14 15 16 18 19]; ifm = 0;
for i = 1:numel(d)
    fcons = spm_select('FPListRec',fullfile(DIR,d(i).name),'con_000.\.nii');   
    if ~isempty(find(i==males,1))
        im = im + 1;
        S.imgfiles{1}{im} = fcons([4 3 8 7],:);
    elseif ~isempty(find(i==females,1))
        ifm = ifm + 1;
        S.imgfiles{2}{ifm} = fcons([4 3 8 7],:);
    end
end

S.contrasts{1}.name = 'Group';
S.contrasts{1}.type = 'F';
S.contrasts{1}.c = [1 1 1 1 -1 -1 -1 -1];

S.contrasts{2}.name = 'Group:G1>G2';
S.contrasts{2}.type = 'T';
S.contrasts{2}.c = [1 1 1 1 -1 -1 -1 -1];

S.contrasts{3}.name = 'Group:G2>G1';
S.contrasts{3}.type = 'T';
S.contrasts{3}.c = [-1 -1 -1 -1 1 1 1 1];

S.contrasts{4}.name = 'Lex';
S.contrasts{4}.type = 'F';
S.contrasts{4}.c = [1 -1 1 -1 1 -1 1 -1];

S.contrasts{5}.name = 'Lex:Word>NonWord';
S.contrasts{5}.type = 'T';
S.contrasts{5}.c = [1 -1 1 -1 1 -1 1 -1];

S.contrasts{6}.name = 'Lex:NonWord>Word';
S.contrasts{6}.type = 'T';
S.contrasts{6}.c = [-1 1 -1 1 -1 1 -1 1];

S.contrasts{7}.name = 'Int (TaskxLex)';
S.contrasts{7}.type = 'F';
S.contrasts{7}.c = [1 -1 -1 1 1 -1 -1 1];

S.contrasts{8}.name = 'Int:HN-HW>EN-EW';
S.contrasts{8}.type = 'T';
S.contrasts{8}.c = [1 -1 -1 1 1 -1 -1 1];

S.contrasts{9}.name = 'Int:EN-EW>HN-HW';
S.contrasts{9}.type = 'T';
S.contrasts{9}.c = [-1 1 1 -1 -1 1 1 -1];

S.contrasts{10}.name = 'Int';
S.contrasts{10}.type = 'F';
S.contrasts{10}.c = [-1 1 1 -1 1 -1 -1 1];

S.contrasts{11}.name = 'Lex_G1';
S.contrasts{11}.type = 'F';
S.contrasts{11}.c = [1 -1 1 -1 0 0 0 0];

S.contrasts{12}.name = 'Lex_G1:Word>NonWord';
S.contrasts{12}.type = 'T';
S.contrasts{12}.c = [1 -1 1 -1 0 0 0 0];

S.contrasts{13}.name = 'Lex_G1:NonWord>Word';
S.contrasts{13}.type = 'T';
S.contrasts{13}.c = [-1 1 -1 1 0 0 0 0];

S.contrasts{14}.name = 'Lex_G2';
S.contrasts{14}.type = 'F';
S.contrasts{14}.c = [0 0 0 0 1 -1 1 -1];

S.contrasts{15}.name = 'Lex_G2:Word>NonWord';
S.contrasts{15}.type = 'T';
S.contrasts{15}.c = [0 0 0 0 1 -1 1 -1];

S.contrasts{16}.name = 'Lex_G2:NonWord>Word';
S.contrasts{16}.type = 'T';
S.contrasts{16}.c = [0 0 0 0 -1 1 -1 1];

% contrasts   - cell array of contrast structures, with fields c
%                  (matrix), type ('F' or 'T') and name (optional)
spm('Defaults','FMRI');
batch_spm_anova(S);



