start_spm; 
clear S
DIR = '/imaging/jc01/Workshop_ta/Analysis/Results/LD/aamod_firstlevel_contrasts_00001';
uname = getenv('USER');
S.outdir = ['/imaging/' uname '/Workshop/LD_PsT_Cov'];

% Order: Easy_WORD (4), Easy_NONWORD (3), Hard_WORD (8), Hard_NONWORD (7)
d = dir(fullfile(DIR,'CBU*'));
for i = 1:numel(d)
    fcons = spm_select('FPListRec',fullfile(DIR,d(i).name),'con_000.\.nii');   
    S.imgfiles{1}{i} = fcons([3 7],:);
end

load('behav.mat');
S.user_regs{1} = horzcat([[behav(:,1).RT]'-mean([behav(:,1).RT]); zeros(numel(d),1)],...
    [zeros(numel(d),1); [behav(:,2).RT]'-mean([behav(:,2).RT])]);

S.contrasts{1}.name = 'Hard > Easy';
S.contrasts{1}.type = 'T';
S.contrasts{1}.c = [-1 1 0 0];

S.contrasts{2}.name = 'RT';
S.contrasts{2}.type = 'T';
S.contrasts{2}.c = [0 0 1 1];

S.contrasts{3}.name = 'RT: E > H';
S.contrasts{3}.type = 'T';
S.contrasts{3}.c = [0 0 1 -1];

S.contrasts{4}.name = 'RT: H > E';
S.contrasts{4}.type = 'T';
S.contrasts{4}.c = [0 0 -1 1];

S.contrasts{5}.name = 'RT: E';
S.contrasts{5}.type = 'T';
S.contrasts{5}.c = [0 0 1 0];

S.contrasts{6}.name = 'RT: E-';
S.contrasts{6}.type = 'T';
S.contrasts{6}.c = [0 0 -1 0];

S.contrasts{7}.name = 'RT: H';
S.contrasts{7}.type = 'T';
S.contrasts{7}.c = [0 0 0 1];

S.contrasts{8}.name = 'RT: H-';
S.contrasts{8}.type = 'T';
S.contrasts{8}.c = [0 0 0 -1];

% contrasts   - cell array of contrast structures, with fields c
%                  (matrix), type ('F' or 'T') and name (optional)
spm('Defaults','FMRI');
batch_spm_anova(S);



