Attribute VB_Name = "modMain"
Dim objSS As New ScannerSync

Const USEPRETENDMODE = True ' Change to false if on mimic or real machine
Const TR = 2000 ' 2000 ms = 2 s
Const NUMDUMMIES = 5
Const NUMTRIALS = 10

Sub Main()

If (USEPRETENDMODE) Then
    objSS.SetPretendMode True
Else
    objSS.Initialize ("") ' Will only run if on a machine with appropriate IO card
End If


Debug.Print "Waiting for first pulse"

' Wait for first pulse
objSS.StartExperiment TR

Debug.Print "Beginning experiment at " & Now()

For i = 1 To NUMDUMMIES
    objSS.SynchroniseExperiment True, 0
    Debug.Print "Found dummy " & i & " at " & objSS.SSGetTimer
Next

For i = 1 To NUMTRIALS
    ' In this example, synchronise every fourth trial
    If (i Mod 4 = 0) Then
        objSS.SynchroniseExperiment True, 0
    End If
        
    Debug.Print "Trial " & i & " start time is " & objSS.SSGetTimer
    ' This is where your trial code would go... instead do a thing that takes a while
    q = 0#
    For j = 1 To 100000
        q = Sin(j) ' a random thing to take some time
    Next
    
    Debug.Print "Current measured TR is " & objSS.GetMeasuredTR

Next

End Sub
