function [filt_output, smth_filt_output, chan_level] = analysis_and_smoothing(input, len_sig_samp, num_chan, filterbank, env_filt)

%% AAB and FG 10/18
% Function to filter input signal into different frequency channels and
% extract smoothed and half-wave rectified envelopes from each frequency
% channel
%
% Inputs
% input - input signal
% len_sig_samp - length of input signal in samples
% num_chan - Number of vocoder channels
% filterbank - previously created filterbank coefficients, created using make_filterbank
% env_filt - previously created envelope filter coefficients, see
% vocoder_CBU_2018
%
% Outputs
% smth_filt_output - matrix of filtered channels, smoothed by the evelope
% filter
%
% e.g.
% [More functions here]
% [smth_filt_output] = analysis_and_smoothing(input, 44100, 16, filterbank, env_filt);

filt_output = zeros(num_chan, len_sig_samp); % Create zero vector for filtered input
chan_level = zeros(1, num_chan); % Create zero vector for channel RMS levels
smth_filt_output = zeros(num_chan, len_sig_samp); % Create zero matrix for  filtered input with smoothed envelope

for nn = 1:num_chan
    
    filt_output(nn,:) = filter(squeeze(filterbank(nn, 2, :)), squeeze(filterbank(nn, 1, :)), input)'; % Filter input signal into frequency channels
    
    chan_level(nn) = norm(filt_output(nn,:), 2); % Get average level of each channel
    
    smth_filt_output(nn,:) = filter(env_filt(2, :), env_filt(1, :), 0.5*(abs(filt_output(nn,:))+filt_output(nn,:))); % half-wave rectify and smooth the filtered signal
    
end