% Script to create pure tones and analyze them
%
% 2018 CBU Matlab course
% 
% F. Gurit


%% Define parameters

duration_signal_s = 2;
fs_Hz = 44100;
amp = 0.1;
freq_sine_Hz = 1000;

%% Create a sinusoid
%
% signal = amp*sin(2*pi*freq_sine_Hz*t_s + theta_rad)
%
%   with t_s your time signal (cf. Part 1)



%% Visualise it
%
%  visualize_signal(signal, fs_Hz, freq_range_to_show_Hz, 'my pure tone')

freq_range_to_show_Hz = [0 10000];

visualize_signal(signal, fs_Hz, freq_range_to_show_Hz, 'my pure tone')

spectrogram_analysis(signal, fs_Hz, freq_range_to_show_Hz, 'my pure tone')

%% Create a second sinuoid and add them together


%% Optional: modulate the sinusoids
%
%  modulator = 0.5*(1 + sin(2*pi*f_mod_Hz*t_s))















































%% Correction

% Create the time vector
time_vec_s = 0:1/fs_Hz:(duration_signal_s-1/fs_Hz);

% Create the sinuoid ( 0 phase here)
signal = amp*sin(2*pi*freq_sine_Hz*time_vec_s + 0);
