function [signal, fs_Hz, len_sig_samp, len_sig_sec, nyquist_freq_Hz] = ...
    load_signal(filename)

% Load audiofile
[input, fs_Hz] = audioread(filename); % Load input speech signal from .wav file and also obtain sampling frequency from the file
nyquist_freq_Hz = fs_Hz/2; % Nyquist limit, highest frequency that can be represented at a given sample rate
len_sig_samp = length(input); % Duration of signal in samples
len_sig_sec = len_sig_samp / fs_Hz; % Duration of signal in seconds
signal = input - mean(input); % Remove any DC offset of the signal (important for rectification)