function [output] = sine_synthesis(sine_tones, smth_filt_output, chan_level, len_sig_samp, num_chan)

%% AAB and FG 10/18
% Function to synthesize sine-vocoded speech from extracted envelopes and
% (cetner-frequency) sine-tone complex
%
% Inputs
% sine_tones - 
% smth_filt_output - 
% chan_level - 
%
% Outputs
% output - 
%
% e.g.
% [More functions here]
% [output] = sine_synthesis(sine_tones, smth_filt_output, chan_level, len_sig_samp, 16);

output_chan = zeros(1, len_sig_samp); % Create zero vector for modulated, smoothed and filtered output channel
output_chan_eq = output_chan; % Create zero vector for equalized output channel
output = zeros(1, len_sig_samp); % Create zero vector for final output of combined channels

for jj = 1:num_chan
    
    output_chan = sine_tones(jj,:) .* smth_filt_output(jj,:); % Multiply modulated and smoothed envelope with sine tone at center frequency of each filter channel
    output_chan_eq = output_chan .* chan_level(jj)/norm(output_chan, 2); % scale output channel waveform to have equal rms to input channel
    output = output + output_chan_eq; % Combine channels to produce output

end