function fftpositive(signal,Fs_Hz)
%fftpositive(signal,Fs_Hz)
%
% Objective: plot the positive frequencies of a FFT analysis
%
% Input
%   -signal: Vector
%   -Fs_Hz: sampling frequency (Hz)
%
% 2018 Matlab Course at the CBU
%
% F. Gurit and A. Archer-Boyd


%Get the normalized fft
signal_spectrum = fft(signal)/(length(signal)/2);

%Take only positive frequencies
signal_spectrum=signal_spectrum(1:ceil(length(signal)/2));

%Create the frequency axis
delta_f=Fs_Hz/(length(signal));
f=0:delta_f:ceil(Fs_Hz/2);
f=f(1:ceil(length(signal)/2));

%Plot the fft power spectrum
plot(f, 20*log10(abs(signal_spectrum)))
xlim([0 Fs_Hz/2])
