function [output] = make_sine(freq, phase, len_sig_sec, samp_freq)

%% AAB and FG 10/18
% Function to create sine tone
%
% Inputs
% freq - sine tone frequency (Hz)
% phase - starting phase (radians)
% len_sig_sec - duration of signal (sec)
% samp_freq - sample rate (Hz)
%
% Outputs
% output - sine tone
%
%e.g. [output] = make_sine(1000, pi/2, 1, 44100);

num_samp = len_sig_sec * samp_freq; % Calculate the number of samples required

output = sin(phase+(2*pi*freq*linspace(0,(len_sig_sec-1/samp_freq), num_samp))); % Creat sine tone, x = sin(phi + 2*pi*freq*time)