function visualize_signal(signal, fs_Hz, freq_range_to_show_Hz, title_str)
% Function to explore a time signal in the time and frequency domain
%
% 2018 Matlab Course at the CBU
%
% F. Gurit and A. Archer-Boyd


%% Create a time axis here
%
% you will likely need to define:
%  - len_sig_samp: the number of samples in your signal
%  - len_sig_sec: the duration of your signal in seconds
%  - time_signal_sec: your time signal, with the time point corresponding
%  to each value in your signal
%
% Useful functions:
%  - linspace


%% Plot time signal

figure
subplot(2, 1, 1)

% Uncomment the following when you have create your time vector
% plot(time_signal_sec, signal, 'linewidth', 1)
plot(signal, 'linewidth', 1)

% Make the plot pretty and informative
ylim([-1 1])
box on
title(['Time domain: ' title_str])

% xlim([0 len_sig_sec])
% xlabel('Time (sec)')


%% Plot spectrogram

subplot(2, 1, 2)

% This calls a function that only takes the positive part of the spectrum
fftpositive(signal, fs_Hz)

% Make the plot pretty and informative
ylim([-90 -10])
title(['Power spectrum: ' title_str])
xlabel('Frequency (Hz)')
ylabel('Power [dB re 1 FS]')
































%% Correction for the time signal


len_sig_samp = length(signal); % Duration of signal in samples
len_sig_sec = len_sig_samp / fs_Hz; % Duration of signal in seconds

% Variant 1
time_signal_sec = 0:1/fs_Hz:(len_sig_sec - 1/fs_Hz);

% Variant 2
time_signal_sec = linspace(0, len_sig_sec - 1/fs_Hz, len_sig_samp);
