function visualize_oscillations(signal, filt_output, num_chan, fs_Hz)
%% AAB and FG 10/18
% Function to plot filter channels produced by the vocoder script
%
% Inputs
% signal - broadband input signal
% filt_output - filtered channels (audio or envelope
% num_chan - Number of vocoder channels
% fs_Hz - sample rate
%
% Outputs
% Plot showing time-domain signals in each channel, and broadband
% time-domain signal
%
% e.g.
% [More functions here]
% visualize_oscillations(input_no_DC, filt_output, num_chan, samp_freq_Hz)


%% Calculate necessary variables

len_sig_samp = length(signal); % Duration of signal in samples
len_sig_sec = len_sig_samp / fs_Hz; % Duration of signal in seconds
time_signal_sec = 0:1/fs_Hz:(len_sig_sec - 1/fs_Hz); % time value in seconds for each sample of the signal

num_plot = num_chan + 2;

%% Plot time signal

figure % Create empty figure

% Plot channels, high to low frequency, top to bottom of plot

for nn = 1:num_plot - 2 

    subplot(num_plot,1,num_plot - (nn+1)); % Create subplot
    plot(time_signal_sec, filt_output(nn,:) , 'linewidth', 1, 'Color', 'k') % Plot channel
    xlim([0 len_sig_sec]) % Set limits of x axis
    ylim([-0.5 0.5]) % Set limits of y axis
    box on % Switch on box display
    title(['Channel ', num2str(nn), ' Time-Domain Signal']); % Set title
    
end
    
% Plot broadband signal across 2 subplots

subplot(num_plot, 1, num_plot-1:num_plot)
plot(time_signal_sec, signal, 'linewidth', 1)

% Again, make last subplot pretty and informative
xlim([0 len_sig_sec])
ylim([-1 1])
box on
title('Broadband Time-Domain Signal')
xlabel('Time (sec)')

