function [beta] = solve_orth_equation(X, y)
% Solve two orthgonal equations yi = xi*betai for betai (i in (1,2)).
% Parameters:
%   X: design matrix, dimension 2x2
%   y: data vector, dimension 2
%   beta: parameter vector, dimension 2
% Returns:
%   beta: parameter vector, dimension 2

    % initialise result vector
    beta = zeros(2,1);

    % Solving equations
    beta(1) = y(1)  /  X(1,1);
    beta(2) = y(2)  /  X(2,2);

end