%% Optimisation

%% Overfitting
x = [0:9];

y = 2 * x';
yn = y + 3*randn(10,1);

plot(x, y, 'r', x, yn, 'b')

% fit a line
% "model" is a line
Y = [0:9]';

% fit model to clean and noisy data
b = pinv(Y)*y
b = pinv(Y)*yn

close all
%% fit data with 10 independent polynomials

% create a matrix Y with polynomials as basis functions
for i = 1:10, Y(:,i) = (x-4.5).^i; end

% check whether the rank is equal to number of samples
% i.e. they are linearly independent
rank(Y)

% compute the pseudoinverse
Ypinv = pinv(Y);

% estimate the parameters from clean data
b = Ypinv*y;
plot(Y*b);

% estimate parameters from noisy data
bn = Ypinv*yn;
plot(Y*bn);

% you can use your parameters to predict new data, between previous samples
a = [0:0.01:9];

data = [0];
% weight the basis functions with their estimated parameters
for i=1:10, data = data + bn(i)*(a-4.5).^i; end

% compare fitted curve with original samples
plot(a, data)
hold on
plot(x, yn, 'rx')

close all

%% now model the line with sines and cosines
% create a matrix with sine/cosine colums as basis functions
clear Y
for i=1:2:10, Y(:,i)=sin(i*x*(pi/10)); Y(:,i+1)=cos(i*x*(pi/10)); end

% check whether basis functions are linearly independent
rank(Y)
imagesc(Y'*Y)

Ypinv = pinv(Y);

% estimate the parameters from clean data
b = Ypinv*y;
plot(Y*b);

% estimate parameters from noisy data
bn = Ypinv*yn;
plot(Y*bn);

% you can use your parameters to predict new data, between previous samples
a = [0:0.01:9];
data = [0];
% weight the basis functions with their estimated parameters
for i=1:2:10, data = data + bn(i)*sin(i*a*(pi/10)) + bn(i+1)*cos(i*a*(pi/10)); end

% plot fitted curve and original samples
plot(a, data)
hold on
plot(x, yn, 'rx')

close all

%% optimisation tools in Matlab

% finding minimum of Matlab's built-in functions
x = fminsearch(@cos,1)
% see also fminbnd


% finding minima for self-defined arithmetic functions
fun = @(x)(0.1*x+cos(x))
x = [-10:0.1:10];
plot(x,fun(x))
% find minima with different starting points
fminsearch(fun,1)  
fminsearch(fun,-1)

% finding minima for any self-defined function
fminsearch(@my_fun,1)  % where "fun" is a function

% finding minima for a function with multiple input parameters
% note: fminbnd vs fminsearch
fminbnd(@(p) find_phase(p, 1, sin([1:100]+1)), -pi, pi)
