
% Load Matlab Variables 
load('C:\Users\aella\Desktop\MATLAB_COURSE_CBU\GLMIIvar.mat');

% Look At The IC Variable In The Workspace
% Check The Size of IC
[p,q] = size(IC)

% Display ICi As an Image Of Size [mxn] where:  m = 15 and n = 12 (p = mxn)
% Example
m = 15; 
n = 12;
IC1 = reshape(IC(:,1), m, n)
figure;  imagesc( IC1 )


% Display all ICs
for i=1:q
   ICi = reshape(IC(:,i), m, n);
   figure;  imagesc( ICi )
end



%=====================
pause;
pause;
%=====================



% Compute the SVD of IC And Display The Singular Value Matrix S
% Discuss About S... How many important Singular Values?
[U,S,Vt] = svd(IC);



%=====================
pause;
pause;
%=====================



% Store the number of important Singular Values in k
k = 3;

% Initiate a Matrix IF[p,k] with random numbers between [0 1]
size(RANDpk)        % Check The Size Of RANDpk = rand(p,3)
IF = RANDpk;        % Initiate


%=====================
pause;
pause;
%=====================




% Now, Use The PSEUDOINVERSE to Compute IF and FC So That: ICr = IF * FC
%------------------------------------------------------------------------
% 1) If ICr[p,q] = IF[p,k]*FC[?] What is The Size Of FC?   (FC[k,q])

% 2a) Compute FC
FC = pinv(IF)*IC;
% 2b) Remove Negative Numbers From FC... How?
i = find(FC<0);  FC(i) = 0;

% 3a) Compute IF
IF = IC*pinv(FC);
% 3b) Remove Negative Numbers From IF...
i = find(IF<0);  IF(i) = 0;

% 4) Compute The Reconstructed Matrix ICr  
ICr = IF*FC;

% 5) Compute The Difference Between IC and ICr... What could it Be?
E = IC - ICr;

% 6) Compute The Root Means Square Between IC and ICr... How
%    RMS = sqrt( mean( sqr(E) ) )
E2 = E.*E;                           % 
RMS = sqrt(  mean( E2(:) )   )



%=====================
pause;
pause;
%=====================

%------------------------------------------------------------------------
% Now, Loop The Whole PSEUDOINVERSE process : MINIMIZATION
%------------------------------------------------------------------------
% Init Variables
j    = 1;            % Number Of Iterations
RMSs = RMS;          % Keep Tract Of All RMS
%|| (RMS > 0.05)

while (j < 100) 
   % Iterate
   j = j+1                    
   
   % Compute FC
   FC = pinv(IF)*IC;
   % Remove Negative Numbers From FC
   i = find(FC<0);  FC(i) = 0;

   % Compute IF
   IF = IC*pinv(FC);
   % Remove Negative Numbers From IF...
   i = find(IF<0);  IF(i) = 0;

   % Compute The Reconstructed Matrix ICr  
   ICr = IF*FC;

   % Compute The Difference Between IC and ICr
   E = IC - ICr;

   % Compute The Root Means Square Between IC and ICr
   E2 = E.*E;
   RMS = sqrt(  mean( E2(:) )   )
   RMSs(j) = RMS; 
   
end



%=====================
pause;
pause;
%=====================


% Display Reconstructed IC = ICR...
for i=1:q
   ICri = reshape(ICr(:,i), m, n);
   figure;  imagesc( ICri )
end



%=====================
pause;
pause;
%=====================


% Display IF...  Size? 
for i=1:k
   IFi = reshape(IF(:,i), m, n);
   figure;  imagesc( IFi )
end


%=====================
pause;
pause;
%=====================


% Display FC...  Size?
figure;
hold on
for i=1:k
   FCi =  FC(i,:);
   
   if i==1
      plot(FCi, '-bo')
   elseif i==2
      plot(FCi, '-ro')
   else
      plot(FCi, '-go')
   end
end
hold off;




%=====================
pause;
pause;
%=====================


% Display RMS...
figure;
plot(RMSs)




%=====================
pause;
pause;
%=====================

% Display Reconstructed E ...
for i=1:q
   Ei = reshape(E(:,i), m, n);
   figure;  imagesc( Ei )
end




