Public Class AttentionTrial
    Inherits ExpTrial
    Dim ED As ExpDisp

    Public ITI = 500
    Public CueDuration = 1000
    Public MonitorPeriodDuration = 6500
    Public TimeBinDuration = 50
    Public MINBINS = 5 ' min stimulus length
    Dim rad As Integer
    Dim spacing As Integer

    Shadows ParentTrialList As AttentionTrialList

    Sub New(ByVal aTrialList)
        MyBase.New(aTrialList)
        ParentTrialList = aTrialList
    End Sub

    Overrides Sub Run()
        Dim i, j
        Dim sp(,,), ang(,) As Double
        Dim dblStartTime As Double = ParentTrialList.ET.GetTimer()

        ED = ParentTrialList.ExperimentalDisplay
        rad = Int(0.06 * ED.Width)
        spacing = 0.216 * ED.Width

        MonitorPeriodDuration = ParamValues("MonitorDur")
        Dim numbins As Integer = MonitorPeriodDuration / TimeBinDuration
        Dim intNumTargets As Integer = 0
        Dim MAXTARGETS = 6 ' across all 4 locations
        Dim intTargetTime() As Integer
        Dim intTargetPos() As Integer
        ReDim intTargetTime(MAXTARGETS - 1)
        ReDim intTargetPos(MAXTARGETS - 1)

        ReDim sp(numbins, 3, 1)
        ReDim ang(numbins, 3)
        Dim dur(3)

        Dim targetprob As Double

        Dim attendto As Integer = ParamValues("attendto")
        If (attendto = 0) Then
            targetprob = 0
        ElseIf (attendto = 3 Or attendto = 12) Then
            targetprob = 0.025
        ElseIf (attendto = 15) Then
            targetprob = 0.0125
        Else
            MsgBox("Target probability not defined for attendto value of " & attendto)
        End If

        For i = 0 To numbins
            For j = 0 To 3
                If (i = 0 Or ((dur(j) > MINBINS) And (Rnd() < 0.3))) Then
                    sp(i, j, 0) = 1
                    If (Rnd() < targetprob And intNumTargets < (MAXTARGETS - 1)) Then
                        sp(i, j, 1) = -1
                        intTargetTime(intNumTargets) = i * TimeBinDuration
                        intTargetPos(intNumTargets) = j
                        intNumTargets = intNumTargets + 1
                    Else
                        sp(i, j, 1) = 1
                    End If
                    ang(i, j) = Rnd() * Math.PI * 2
                    dur(j) = 0
                Else
                    sp(i, j, 0) = sp(i - 1, j, 0)
                    sp(i, j, 1) = sp(i - 1, j, 1)
                    ang(i, j) = ang(i - 1, j)
                End If
                dur(j) = dur(j) + 1
            Next
        Next

        AddParameter("TrialStartTime", dblStartTime + CueDuration)    ' Actually store start of stimulus block not cue
        AddParameter("TotalNumberOfTargets", intNumTargets + 1)

        For i = 0 To MAXTARGETS - 1
            AddParameter("TargetTime" & i, intTargetTime(i))
            AddParameter("TargetPos" & i, intTargetPos(i))
        Next

        If (ParamValues("AttendTo") = 0) Then
            ED.ClearScreen()
            ParentTrialList.ET.WaitForTime(dblStartTime + CueDuration, Responses)
            ED.DrawFixation()
            ED.FlipSurface()
        Else
            DrawCue()
            Debug.Print("***")

            ParentTrialList.ET.ResetResponseExpectancy()
            ParentTrialList.ET.WaitForTime(dblStartTime + CueDuration, Responses)

            Dim mytarget As Integer
            For i = 0 To numbins - 1
                For j = 0 To intNumTargets - 1
                    If (i = intTargetTime(j)) Then
                        mytarget = 1 << intTargetPos(j)
                    Else
                        mytarget = 0
                    End If
                Next

                Dim discmask As Integer

                If (frmStart.rbConstant.Checked) Then
                    discmask = 15
                Else
                    discmask = (Rnd() * 15)
                End If
                RunDrawDiscs(discmask, sp, ang, i)
                ParentTrialList.ET.WaitForTime(dblStartTime + CueDuration + TimeBinDuration * (i + 1), Responses)
            Next
        End If
        ED.DrawFixation()
        ED.FlipSurface()
        ParentTrialList.ET.WaitForTime(dblStartTime + CueDuration + MonitorPeriodDuration + ITI, Responses)

        Const MINRT = 100
        Const MAXRT = 1600
        Dim intHit As Integer
        Dim intFA As Integer
        Dim booUsedTarget() As Boolean
        ReDim booUsedTarget(intNumTargets - 1)
        For Each myresp As AResponse In Responses
            For i = 0 To intNumTargets - 1
                Dim intMask As Integer = 8 >> intTargetPos(i)
                If ((intMask And ParamValues("AttendTo")) <> 0) And Not (booUsedTarget(i)) Then
                    Dim RT As Double = myresp.ResponseTime - dblStartTime - CueDuration - intTargetTime(i)
                    If (RT > MINRT And RT < MAXRT) Then
                        intHit = intHit + 1
                        booUsedTarget(i) = True
                        Exit For
                    End If
                End If
            Next
            If (i = intNumTargets) Then
                intFA = intFA + 1
            End If
        Next
        Dim intTot As Integer
        For i = 0 To intNumTargets - 1
            Dim intMask As Integer = 8 >> intTargetPos(i)
            If ((intMask And ParamValues("AttendTo")) <> 0) Then
                intTot = intTot + 1
            End If
        Next
        AddParameter("Hits", intHit)
        AddParameter("FA", intFA)
        AddParameter("TargetsAtAttendedPositions", intTot)

        Dim MeasuredTR, LastPulseNum, LastPulseTIme
        ParentTrialList.ET.LogScannerStuff(MeasuredTR, LastPulseNum, LastPulseTime)
        AddParameter("GetMeasuredTR", MeasuredTR)
        AddParameter("GetLastPulseNum", LastPulseNum)
        AddParameter("GetLastPulseTime", LastPulseTIme)



    End Sub
    Sub DrawCue()
        Dim AttendTo As Integer = ParamValues("AttendTo")
        Dim bitmask As Integer = 8
        Dim i, cx As Integer
        Dim radex = 4
        ED.DrawFixation()
        Dim h As Integer = ED.DXSurfBack.GetDc()
        Dim g As Graphics
        g = Graphics.FromHdc(h)
        Dim myframepen As New Pen(Color.White, 1)
        Dim mycuepen As New Pen(Color.Red, 3)
        For i = 0 To 3
            cx = ED.MidX + (i - 1.5) * spacing
            ED.DXSurfBack.ForeColor = Color.White
            g.DrawEllipse(myframepen, cx - rad, ED.MidY - rad, rad * 2, rad * 2)
            If (bitmask And AttendTo) Then
                g.DrawEllipse(mycuepen, cx - rad - radex, ED.MidY - rad - radex, 2 * (rad + radex), 2 * (rad + radex))
            End If
            bitmask = bitmask >> 1
        Next
        ED.DXSurfBack.ReleaseDc(h)
        ED.FlipSurface()

    End Sub

    Overridable Sub oldRunDrawDiscs(ByVal DiscPattern, ByVal sp, ByVal ang, ByVal tp)
        Dim dblDrawStart As Double = ParentTrialList.ET.GetTimer()

        ED.DrawFixation()

        ' Get a graphics object
        Dim dc As System.IntPtr
        dc = ED.DXSurfBack.GetDc()
        Dim g As Graphics
        g = Graphics.FromHdcInternal(dc)

        Dim i, cx As Integer
        Dim bitmask As Integer = 8
        For i = 0 To 3
            Dim spatperiod1 = sp(tp, i, 0)
            Dim spatperiod2 = sp(tp, i, 1)
            Dim ang1 = ang(tp, i)

            cx = ED.MidX + (i - 1.5) * spacing
            Dim framepen As New Pen(Color.Yellow)
            g.DrawEllipse(framepen, CSng(cx - rad), CSng(ED.MidY - rad), CSng(rad * 2), CSng(rad * 2))
            If (DiscPattern And bitmask) Then
                Dim ca1, sa1 As Double
                ca1 = Math.Cos(ang1)
                sa1 = Math.Sin(ang1)
                Dim xt1, xt2, yt1, yt2, y As Single
                For y = -rad To rad Step 0.5
                    Dim x As Integer = Math.Round(Math.Sqrt(rad * rad - y * y))
                    Dim gr As Integer = Int(127 * (1 + Math.Sin(2 * Math.PI * y / spatperiod1)))
                    '                   ED.DXSurfBack.ForeColor = Color.FromArgb(gr, gr, gr)
                    '                    Dim mybrush As New SolidBrush(Color.FromArgb(128, gr, gr, gr))
                    Dim mypen As New Pen(Color.FromArgb(255, gr, gr, gr))
                    xt1 = -x * ca1 - y * sa1
                    yt1 = -x * sa1 + y * ca1
                    xt2 = x * ca1 - y * sa1
                    yt2 = x * sa1 + y * ca1
                    g.DrawLine(mypen, cx + xt1, ED.MidY + yt1, cx + xt2, ED.MidY + yt2)
                Next
                If (spatperiod2 > 0) Then
                    ca1 = Math.Cos(ang1 + Math.PI / 2)
                    sa1 = Math.Sin(ang1 + Math.PI / 2)
                    For y = -rad To rad Step 0.5
                        Dim x As Integer = Math.Round(Math.Sqrt(rad * rad - y * y))
                        Dim gr As Integer = Int(127 * (1 + Math.Sin(2 * Math.PI * y / spatperiod2)))
                        xt1 = -x * ca1 - y * sa1
                        yt1 = -x * sa1 + y * ca1
                        xt2 = x * ca1 - y * sa1
                        yt2 = x * sa1 + y * ca1
                        Dim mypen As New Pen(Color.FromArgb(128, gr, gr, gr))
                        g.DrawLine(mypen, cx + xt1, ED.MidY + yt1, cx + xt2, ED.MidY + yt2)
                    Next
                End If
            End If
            bitmask = bitmask >> 1
        Next
        ED.DXSurfBack.ReleaseDc(dc)
        ED.FlipSurface()
    End Sub

    Overridable Sub RunDrawDiscs(ByVal DiscPattern, ByVal sp, ByVal ang, ByVal tp)
        Dim dblDrawStart As Double = ParentTrialList.ET.GetTimer()

        ED.DrawFixation()
        ' Get a graphics object
        Dim dc As System.IntPtr
        dc = ED.DXSurfBack.GetDc()
        Dim g As Graphics
        g = Graphics.FromHdcInternal(dc)

        Dim i, cx As Integer
        Dim gr

        Dim bitmask As Integer = 8
        Dim istarget As Integer
        For i = 0 To 3
            Dim spatperiod1 = sp(tp, i, 0)
            Dim spatperiod2 = sp(tp, i, 1)
            Dim ang1 = ang(tp, i)
            If (spatperiod2 = -1) Then
                istarget = 1
            Else
                istarget = 0
            End If

            cx = ED.MidX + (i - 1.5) * spacing
            If (DiscPattern And bitmask) Then
                g.DrawImage(ParentTrialList.b(istarget, Int(ang1 / 2 / Math.PI * ParentTrialList.numbitmap)), cx - rad, ED.MidY - rad)
            End If
            bitmask = bitmask >> 1
        Next

        ED.DXSurfBack.ReleaseDc(dc)
        ED.FlipSurface()
    End Sub

    Overridable Sub old2RunDrawDiscs(ByVal DiscPattern, ByVal sp, ByVal ang, ByVal tp)
        Dim dblDrawStart As Double = ParentTrialList.ET.GetTimer()

        ED.DrawFixation()
        ' Get a graphics object
        Dim dc As System.IntPtr
        dc = ED.DXSurfBack.GetDc()
        Dim g As Graphics
        g = Graphics.FromHdcInternal(dc)

        Dim i, cx As Integer
        Dim gr

        Dim bitmask As Integer = 8
        For i = 0 To 3
            Dim spatperiod1 = sp(tp, i, 0)
            Dim spatperiod2 = sp(tp, i, 1)
            Dim ang1 = ang(tp, i)

            cx = ED.MidX + (i - 1.5) * spacing
            Dim framepen As New Pen(Color.Yellow)
            g.DrawEllipse(framepen, CSng(cx - rad), CSng(ED.MidY - rad), CSng(rad * 2), CSng(rad * 2))
            If (DiscPattern And bitmask) Then
                Dim ca1, sa1 As Double
                ca1 = Math.Cos(ang1)
                sa1 = Math.Sin(ang1)
                Dim xt1, xt2, yt1, yt2, y As Single
                For y = -rad To rad Step spatperiod1
                    Dim x As Integer = Math.Round(Math.Sqrt(rad * rad - y * y))
                    xt1 = -x * ca1 - y * sa1
                    yt1 = -x * sa1 + y * ca1
                    xt2 = x * ca1 - y * sa1
                    yt2 = x * sa1 + y * ca1
                    Dim mypen As New Pen(Color.Beige, 4)
                    g.DrawLine(mypen, cx + xt1, ED.MidY + yt1, cx + xt2, ED.MidY + yt2)
                Next
                If (spatperiod2 > 0) Then
                    ca1 = Math.Cos(ang1 + Math.PI / 2)
                    sa1 = Math.Sin(ang1 + Math.PI / 2)
                    For y = -rad To rad Step spatperiod2
                        Dim x As Integer = Math.Round(Math.Sqrt(rad * rad - y * y))
                        xt1 = -x * ca1 - y * sa1
                        yt1 = -x * sa1 + y * ca1
                        xt2 = x * ca1 - y * sa1
                        yt2 = x * sa1 + y * ca1

                        Dim mypen As New Pen(Color.Beige, 4)
                        g.DrawLine(mypen, cx + xt1, ED.MidY + yt1, cx + xt2, ED.MidY + yt2)
                    Next
                End If
            End If
            bitmask = bitmask >> 1
        Next

        ED.DXSurfBack.ReleaseDc(dc)
        ED.FlipSurface()
    End Sub
End Class
