Imports System
Imports System.IO

Public Class AttentionTrialList
    Inherits ExpTrialList
    Dim rad
    Public b(,) As Bitmap
    Public numbitmap = 50

    Sub New(ByVal NewNumTrials, ByVal NewOutputFilename, ByVal NewSubjectCode)
        MyBase.New(NewNumTrials, NewOutputFilename, NewSubjectCode)
        Dim i
        For i = 0 To NumTrials - 1
            TrialList(i) = New AttentionTrial(Me)
        Next
    End Sub

    Function getstimdir()
        Return (Application.StartupPath & "\stim")
    End Function

    Function getfn(ByVal k, ByVal j) As String

        Return (getstimdir & "\grating_" & k & "_" & j & ".bmp")
    End Function

    Sub PrepareStimuli()
        ReDim b(1, numbitmap)
        ExperimentalDisplay.DXSurfBack.ColorFill(ExperimentalDisplay.ES.BackColour)

        Try
            For k As Integer = 0 To 1
                For j As Integer = 0 To numbitmap
                    b(k, j) = New Bitmap(getfn(k, j))
                Next
            Next
        Catch ex As Exception
            Try
                Directory.CreateDirectory(getstimdir)
            Catch ex2 As Exception
            End Try
            ExperimentalDisplay.DXSurfBack.DrawText(100, ExperimentalDisplay.MidY, "First time use - preparing stimuli.", False)
            ExperimentalDisplay.FlipSurface()


            Randomize()
            Dim prepstart = ET.GetTimer()
            For k As Integer = 0 To 1
                For j As Integer = 0 To numbitmap

                    rad = Int(0.06 * ExperimentalDisplay.Width)
                    Dim i, x

                    Dim mysintab(255)
                    For i = 0 To 255
                        mysintab(i) = Int(127.5 * (1.0 + Math.Sin(2 * Math.PI * i / 255)))
                    Next

                    Dim spatperiod1 As Double = rad / (1 + Rnd() * 2)
                    Dim spatperiod2 As Double = rad / (1 + Rnd() * 2)
                    Dim cx = rad
                    b(k, j) = New Bitmap(CShort(rad * 2 + 1), CShort(rad * 2 + 1))
                    Dim g As Graphics = Graphics.FromImage(b(k, j))
                    g.Clear(Me.ExperimentalDisplay.ES.BackColour)
                    Dim ang1 As Double = Rnd() * 2 * Math.PI
                    Dim ca1, sa1
                    ca1 = Math.Cos(ang1)
                    sa1 = Math.Sin(ang1)
                    Dim ind, ind2, gr As Integer
                    i = 0
                    Dim mypic(rad * rad * 4) As Byte
                    For y As Integer = -rad To rad
                        Dim w As Integer = Math.Round(Math.Sqrt(rad * rad - y * y))
                        For x = -w To w
                            If (k = 0) Then
                                ind = (Int(255 * (10000 + (ca1 * x - sa1 * y) / spatperiod1))) Mod 256
                                ind2 = (Int(255 * (10000 + (sa1 * x + ca1 * y) / spatperiod2))) Mod 256
                                gr = (mysintab(ind) + mysintab(ind2)) / 2
                            Else
                                ind = (Int(127.5 - 255 / (Math.Sqrt(2) * 2) + 255 / Math.Sqrt(2) * (10000 + (ca1 * x - sa1 * y) / spatperiod1))) Mod 256
                                gr = mysintab(ind)
                            End If
                            i = i + 1
                            b(k, j).SetPixel(x + rad, y + rad, Color.FromArgb(gr, gr, gr))
                        Next
                    Next
                    b(k, j).Save(getfn(k, j), System.Drawing.Imaging.ImageFormat.Bmp)
                    Debug.Print(getfn(k, j))
                Next
            Next

            Debug.Print("Preparation time " & ET.GetTimer())

            ExperimentalDisplay.DXSurfBack.ColorFill(ExperimentalDisplay.ES.BackColour)
            ExperimentalDisplay.FlipSurface()
        End Try
    End Sub

End Class
