Imports Microsoft.DirectX
Imports Microsoft.DirectX.DirectDraw
Imports Microsoft.DirectX.Direct3D
Imports Microsoft.DirectX.Direct3D.D3DX

Public Class ExpDisp
    Public DXDevice As New DirectDraw.Device
    Public DXSurfPrimary As DirectDraw.Surface
    Public DXSurfBack As DirectDraw.Surface
    Public DXSurfDesc As New DirectDraw.SurfaceDescription
    Public DXSurfBackCaps As DirectDraw.SurfaceCaps
    Public canvas As DirectDraw.Surface
    Public DisplayForm As Form
    Public Width, Height As Integer
    Public MidX, MidY As Integer

    Public ES As New ExpSettings

    Public FixationSize = 0.01 ' as a proportion of screen width

    Public Sub Initialize()

        ExpStimulusForm.Visible = True


        ' Make primary surface
        If ES.FullScreen = True Then
            DXDevice.SetCooperativeLevel(ExpStimulusForm, CooperativeLevelFlags.Fullscreen Or CooperativeLevelFlags.Exclusive)
            DXDevice.SetDisplayMode(ES.ScreenWidth, ES.ScreenHeight, 32, 0, False)
            DXSurfDesc.SurfaceCaps.Flip = True
            DXSurfDesc.SurfaceCaps.Complex = True
            DXSurfDesc.BackBufferCount = 1
            Width = ES.ScreenWidth
            Height = ES.ScreenHeight
        Else
            DXDevice.SetCooperativeLevel(ExpStimulusForm, CooperativeLevelFlags.Normal)
        End If
        DXSurfDesc.SurfaceCaps.PrimarySurface = True
        DXSurfPrimary = New DirectDraw.Surface(DXSurfDesc, DXDevice)

        ' Now sort out the back buffer, either real or pretend
        If ES.FullScreen Then
            Dim DXSurfBackCaps As New SurfaceCaps
            DXSurfBackCaps.BackBuffer = True
            DXSurfBack = DXSurfPrimary.GetAttachedSurface(DXSurfBackCaps)
        Else
            'Or make one up (Danny's trick!)
            DXSurfDesc.Clear()
            DXSurfDesc.Width = ExpStimulusForm.Width
            DXSurfDesc.Height = ExpStimulusForm.Height
            DXSurfDesc.SurfaceCaps.OffScreenPlain = True
            DXSurfBack = New DirectDraw.Surface(DXSurfDesc, DXDevice)
            Width = ExpStimulusForm.Width
            Height = ExpStimulusForm.Height
        End If

        MidX = Width / 2
        MidY = Height / 2

        ClearScreen()
    End Sub

    Public Sub ClearScreen()
        DXSurfBack.ColorFill(ES.BackColour)
        FlipSurface()
    End Sub
    Public Sub DrawFixation()
        Dim fixpix As Integer = FixationSize * Width
        Dim wid = 2
        DXSurfBack.ColorFill(ES.BackColour)
        DXSurfBack.ForeColor = Color.Red
        DXSurfBack.FillColor = Color.Red
        DXSurfBack.DrawBox(MidX - fixpix, MidY - wid, MidX + fixpix + 1, MidY + wid + 1)
        DXSurfBack.DrawBox(MidX - wid, MidY - fixpix, MidX + wid + 1, MidY + fixpix + 1)
    End Sub


    Public Sub FlipSurface()
        If (ES.FullScreen) Then
            DXSurfPrimary.Flip(Nothing, FlipFlags.DoNotWait)
        Else
            DXSurfPrimary.DrawFast(ExpStimulusForm.Left, ExpStimulusForm.Top, DXSurfBack, DrawFastFlags.DoNotWait)
        End If
    End Sub

    Public Sub Terminate()
        DXDevice.RestoreDisplayMode()
    End Sub
End Class
