Imports Microsoft.DirectX
Imports Microsoft.DirectX.DirectInput
Imports Microsoft.DirectX.Directdraw

#Const USESCANNERSYNC = False    ' This is a compiler directive, which means lines using library can be omitted at compilation - good if library isn't on machine at all
#Const USEBUTTONBOX = False
#Const DONTWAITATALL = False

Public Class ExpTimingAndResponses

    Public PRETENDMODE As Boolean = False
    Public TR As Integer = 2000
    Public intNumDummies = 5
    Public DXInputKeyboard As DirectInput.Device
    Public ED As ExpDisp
    ' recent key press states 
    Dim lastresptime
    Dim lastkeyresptime
#If USEBUTTONBOX Then
    Dim oldresp, resp
#End If
    Dim keyresp
    Dim oldkeyresp

    Declare Function StartTimerInternal Lib "perfpres.dll" Alias "_StartTimer@0" () As Long
    Declare Function GetTimerInternal Lib "perfpres.dll" Alias "_GetTimer@0" () As Double
    Declare Sub PumpUpTheThreadPriorityInternal Lib "perfpres.dll" Alias "_PumpUpTheThreadPriority@0" ()
    Declare Sub RestoreThreadPriorityInternal Lib "perfpres.dll" Alias "_RestoreThreadPriority@0" ()
    Declare Function WaitForTimeInternal Lib "perfpres.dll" Alias "_WaitForTime@8" (ByVal mytime As Double) As Double

#If USESCANNERSYNC Then
    Public objSS As New MRISync.ScannerSync
#End If
   
    Public Sub New()
        StartTimerInternal()
    End Sub

    Public Sub InitKeyboard(ByVal FormHandle)
        DXInputKeyboard = New DirectInput.Device(DirectInput.SystemGuid.Keyboard)
        DXInputKeyboard.SetCooperativeLevel(FormHandle, DirectInput.CooperativeLevelFlags.Foreground Or DirectInput.CooperativeLevelFlags.NonExclusive)
        'DirectInput.CooperativeLevelFlags.Foreground Or DirectInput.CooperativeLevelFlags.Exclusive
    End Sub
    Public Sub WaitForTime(ByVal dblTime As Double)
        Dim lastresptime = -999

        While (GetTimer() < (dblTime - 5))
#If USESCANNERSYNC Then
            ' Listens for pulses & checks responses if using scanner...
            objSS.CheckPulseSynchronyForTime(1)
#End If
            Application.DoEvents()
            Dim ckbs = DXInputKeyboard.GetCurrentKeyboardState()
            If (ckbs.item(Key.Escape)) Then
                Application.Exit()
            End If
        End While
        WaitForTimeInternal(dblTime)
    End Sub

    Public Sub ResetResponseExpectancy()
        lastresptime = -999
        lastkeyresptime = -999
#If USEBUTTONBOX Then
        oldresp = objSS.GetResponse And 30
#End If
        keyresp = Nothing
        oldkeyresp = False

    End Sub
    Public Sub WaitForTime(ByVal dblTime As Double, ByRef Responses As Collection)
#If DONTWAITATALL Then
        Application.DoEvents()
        Return
#End If

        While (GetTimer() < (dblTime - 10))
#If USESCANNERSYNC Then
            ' Listens for pulses & checks responses if using scanner...
            objSS.CheckPulseSynchronyForTime(1)
#End If

            Application.DoEvents()
#If USEBUTTONBOX Then
            resp = objSS.GetResponse And 30
            'check key just pressed and min time 10ms between responses
            If (resp <> 30 And oldresp = 30 And (GetTimer() - lastresptime) > 10) Then
                Dim aresp As New AResponse
                aresp.KeyCode = resp
                aresp.ResponseTime = GetTimer()
                lastresptime = GetTimer()
                Responses.Add(aresp)
            End If
            oldresp = resp
#Else
            DXInputKeyboard.Acquire()
            Dim ckbs = DXInputKeyboard.GetCurrentKeyboardState()
            If (ckbs.item(Key.Escape)) Then
                Application.Exit()
            ElseIf (ckbs.item(Key.Return)) Then
                keyresp = 13
            Else
                keyresp = Nothing
            End If


            If ((Not keyresp Is Nothing) And (Not oldkeyresp)) Then
                Dim aresp As New AResponse
                aresp.KeyCode = keyresp
                aresp.ResponseTime = GetTimer()
                Responses.Add(aresp)
                Debug.Print("Got key response")
            End If
            ' Wait until at least 50 ms of peace before listening again
            If (Not keyresp Is Nothing) Then
                lastkeyresptime = GetTimer()
            End If
            If ((GetTimer() - lastkeyresptime) > 50) Then
                oldkeyresp = False
            Else
                oldkeyresp = True
            End If
#End If
        End While
        WaitForTimeInternal(dblTime)
    End Sub

    Public Function StartTimer() As Long
        Return (StartTimerInternal())
    End Function
    Public Function GetTimer() As Double
        Return (GetTimerInternal())
    End Function

    Public Function Initialise(ByVal OutputFilename)
#If USESCANNERSYNC Then
        If (PRETENDMODE) Then
            objSS.SetPretendMode(True)
        Else
            objSS.Initialize("")
        End If
        ED.DXSurfBack.ColorFill(ED.ES.BackColour)
        ED.DXSurfBack.DrawText(ED.MidX - 20, ED.MidY, Str(intNumDummies), False)
        ED.FlipSurface()
        objSS.StartExperiment(TR)
        Application.DoEvents()
        ' one pulse already received by start experiment
        For i As Integer = 1 To intNumDummies - 1
            Application.DoEvents()
            ED.DXSurfBack.ColorFill(ED.ES.BackColour)
            ED.DXSurfBack.DrawText(ED.MidX - 20, ED.MidY, Str(intNumDummies - i), False)
            ED.FlipSurface()
            objSS.SynchroniseExperiment(True, 0)
            System.IO.File.AppendAllText(OutputFilename, "Got dummy scan " & i & " at " & vbTab & GetTimer() & vbCrLf)
        Next
#Else
        Call StartTimer()
#End If

    End Function

    Public Function LogScannerStuff(ByRef MeasuredTR, ByRef LastPulseNum, ByRef LastPulseTime)
#If USESCANNERSYNC Then
        MeasuredTR = objSS.GetMeasuredTR()
        LastPulseNum = objSS.GetLastPulseNum(True)
        LastPulseTime = objSS.GetLastPulseTime(True)
#End If

    End Function
End Class
