#Const USESCANNERSYNC = True

Public Class ExpTrialList
    Public TrialList() As ExpTrial
    Public NumTrials As Integer
    Public OutputFilename As String = "test.xls"
    Public SubjectCode As String = ""
    Public ExperimentalDisplay As ExpDisp
    Public ET As ExpTimingAndResponses
    Public MaxNumberOfResponses = 1

    Sub New(ByVal NewNumTrials, ByVal NewOutputFilename, ByVal NewSubjectCode)
        NumTrials = NewNumTrials
        SubjectCode = NewSubjectCode
        OutputFilename = NewOutputFilename
        ET = New ExpTimingAndResponses
        ReDim TrialList(NumTrials - 1)
        Dim i
        For i = 0 To NumTrials - 1
            TrialList(i) = New ExpTrial(Me)
        Next
    End Sub
    Overridable Sub RandomizeTrialOrder()
        RandomizeTrialOrder(False)
    End Sub

    Overridable Sub SetExperimentalDisplay(ByVal NewExperimentalDisplay)
        ExperimentalDisplay = NewExperimentalDisplay
        ET.ED = NewExperimentalDisplay
    End Sub

    Overridable Sub RunAllTrials()
        Dim i
        System.IO.File.AppendAllText(OutputFilename, "*** Starting experiment at " & Now() & vbCrLf)

        ' Is this an MRI experiment? If so, start library and collect dummy scans - if not start timer
        ET.Initialise(OutputFilename)

        System.IO.File.AppendAllText(OutputFilename, "Subject" & vbTab & "Trial" & vbTab)


        For i = 0 To NumTrials - 1
            TrialList(i).Run()
            If (i = 0) Then
                TrialList(0).DumpParamHeadersToFile()
                System.IO.File.AppendAllText(OutputFilename, vbCrLf)
            End If
            System.IO.File.AppendAllText(OutputFilename, SubjectCode & vbTab)
            System.IO.File.AppendAllText(OutputFilename, i & vbTab)
            TrialList(i).DumpParamsToFile()
            System.IO.File.AppendAllText(OutputFilename, vbCrLf)
        Next
        System.IO.File.AppendAllText(OutputFilename, "*** Finished experiment at " & Now() & vbCrLf)
    End Sub

    Overridable Sub RandomizeTrialOrder(ByVal PreserveSubblocks)
        ' Randomizes the order of all of the trials, keeping the parameter description for each
        '  individual trial intact
        Randomize()
        Dim rand() As Double
        ReDim rand(NumTrials)
        Dim i
        For i = 0 To NumTrials - 1
            If (PreserveSubblocks) Then
                rand(i) = Rnd() + TrialList(i).ParamValues("Subblock")
            Else
                rand(i) = Rnd()
            End If
        Next

        ' Bubblesort
        Dim tmp As Object
        Dim booSwap As Boolean = True
        While (booSwap)
            booSwap = False
            For i = 0 To NumTrials - 2
                If (rand(i) > rand(i + 1)) Then
                    tmp = TrialList(i)
                    TrialList(i) = TrialList(i + 1)
                    TrialList(i + 1) = tmp
                    tmp = rand(i)
                    rand(i) = rand(i + 1)
                    rand(i + 1) = tmp
                    booSwap = True
                End If
            Next
        End While
    End Sub

    Overridable Sub RandomizeTrialOrderSingleParameter(ByVal ParamName)
        ' Randomizes a single parameter of all of the trials independently of all of the others
        Randomize()
        Dim rand() As Double
        ReDim rand(NumTrials)
        Dim i
        For i = 0 To NumTrials - 1
            rand(i) = Rnd()
        Next

        ' Bubblesort
        Dim tmp As Object
        Dim booSwap As Boolean = True
        While (booSwap)
            booSwap = False
            For i = 0 To NumTrials - 2
                If (rand(i) > rand(i + 1)) Then
                    tmp = TrialList(i).ParamValues(ParamName)
                    TrialList(i).ParamValues.Remove(ParamName)
                    TrialList(i).ParamValues.Add(TrialList(i + 1).ParamValues(ParamName), ParamName)
                    TrialList(i + 1).ParamValues.Remove(ParamName)
                    TrialList(i + 1).ParamValues.Add(tmp, ParamName)
                    tmp = rand(i)
                    rand(i) = rand(i + 1)
                    rand(i + 1) = tmp
                    booSwap = True
                End If
            Next
        End While
    End Sub

End Class

