Public Class frmStart
    ' Requires 394 scans at TR=2, 13.1 mins
    ' To check: 
    '   eccentricity and size of stimuli
    '   ignore central position

    Dim ED As New ExpDisp


    Private Sub cmdStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdStart.Click
        ED.Initialize()


        ' Make up trials
        Dim TL As AttentionTrialList
        Dim NUMCONDS = 4
        Dim NUMSUBBLOCKS = 12
        Dim ATTENDLIST() = {0, 3, 12, 15}
        Dim i, j
        Dim ind = 0
        TL = New AttentionTrialList(NUMCONDS * NUMSUBBLOCKS, txtOutputFilename.Text, txtSubjectCode.Text)

        TL.SetExperimentalDisplay(ED)
        TL.MaxNumberOfResponses = 8

        TL.PrepareStimuli()

        ED.DrawFixation()

        Dim MINBLOCKDUR = 4000
        Dim MAXBLOCKDUR = 9000

        For i = 0 To NUMSUBBLOCKS - 1
            For j = 0 To NUMCONDS - 1
                TL.TrialList(ind).AddParameter("Subblock", i)
                TL.TrialList(ind).AddParameter("MonitorDur", ((MAXBLOCKDUR - MINBLOCKDUR) * i / (NUMSUBBLOCKS - 1.0)) + MINBLOCKDUR)
                TL.TrialList(ind).AddParameter("AttendTo", ATTENDLIST(j))
                ind = ind + 1
            Next
        Next

        ' Randomise
        TL.RandomizeTrialOrderSingleParameter("MonitorDur")
        TL.RandomizeTrialOrder(True)

        ' Initialize keyboard
        TL.ET.InitKeyboard(ExpStimulusForm)

        ' Flush form change and so on
        Application.DoEvents()

        ' Run
        TL.RunAllTrials()

        ED.DXSurfBack.ColorFill(ED.ES.BackColour)
        ED.DXSurfBack.DrawText(100, ED.MidY, "Thank you - this block nearly complete.", False)
        TL.ET.WaitForTime(TL.ET.GetTimer() + 120000)
        ' Finish
        ED.Terminate()

    End Sub




    Private Sub cmdPrepare_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

    End Sub
End Class
