
C  'KANT' -- A FORTRAN PROGRAM TO COMPUTE MARDIA'S (1974, 1983)
C          MEASURES OF MULTIVARIATE SKEW AND KURTOSIS IN A DATA SET
C		       BY RANDALL MACINTOSH, 1991.
C                        WAYNE STATE UNIVERSITY
C	   VERSION 1.0 -- LIMITED TO 1000 OBSERVATIONS AND 10 VARIABLES
C	 SUBROUTINES LUBKSB, LUDCMP, GAMMQ, GCF, GSER, GAMMLN ARE
C	  FROM PRESS, ET AL (1985). SOME OF THESE ROUTINES ARE
C	  MODIFIED SLIGHTLY TO CORRECT TYPOS IN THE SOURCE.
C	 MARDIA'S WB1, WB2 AND K ARE CALCULATED AS DESCRIBED IN
C	  BOLLEN (1989) PP. 423-424.
C
C
$LARGE
	REAL*8 S(10,10), U(10,10), SUM(10), AVE(10),
     +	Y(10,10), DD, T, ND,
     +	B1,B2, WB1, WB2, K2, X(2000,10), Z, B2SIG,
     +	K2SIG, WB1SIG, WB2SIG, CSQB1, BSIG, P1, P2
	INTEGER  NP, I, V, N, DF
	CHARACTER*64 FILEIN
	CHARACTER*14 FMAT
	CHARACTER*1 GO
	DIMENSION INDX(2000)
	NP=10
        B1=0.0
	B2=0.0
1	WRITE (*,'(/A\)') ' INPUT FILE NAME -------> '
	READ (*,'(A)') FILEIN
	WRITE (*,'(A\)') ' NUMBER OF VARIABLES ---> '
	READ (*,'(I4)') V
	IF (V .GT. 10) THEN
	WRITE (*,*) '  TOO MANY VARIABLES -- LIMIT IS 10'
	GOTO 999
	END IF
	FMAT='(  (1X,F10.4))'
	IF (V .GT. 7) FMAT='(  (1X,F7.2))'
	WRITE(FMAT(2:3),'(I2)') V
	OPEN (7,FILE=FILEIN,STATUS='OLD',ERR=5)
        I=0
10      I=I+1
	READ (7,*,END=98)  (X(I,J),J=1,V)
	IF (I .LE. 2000) GOTO 10
98	CLOSE (7)
	GOTO 6
5	WRITE(*,'(/A,A\)') '	    CANNOT FIND ', FILEIN
	WRITE(*,'(A\)') '    CONTINUE (Y or N)? '
	READ (*,'(A)') GO
	J=SCAN(GO,'Nn')
	IF (J .LT. 1) THEN
	GOTO 1
	ELSE
	GOTO 999
	END IF
6	N=I-1
	WRITE (*,699) N
699	FORMAT (' ', I4, ' RECORDS READ')
	IF (N .LT. 50) THEN
	WRITE (*,'(/A,I2,A)') '    WARNING: YOU HAVE ', N, ' CASES'
	WRITE (*,'(A\)') '    FEWER THAN 50 MAY RESULT IN'
	WRITE (*,'(A/)') ' UNRELIABLE ESTIMATES'
	END IF
        DO 12 J=1,V
        SUM(J)=0.0
        AVE(J)=0.0
12      CONTINUE
C                 CALCULATE SUMS = SUM
        DO 16 J=1,V
        DO 14 I=1,N
        SUM(J)=SUM(J)+X(I,J)
14      CONTINUE
16      CONTINUE
C		   CALCULATE MEANS = AVE(J)
	ND=DFLOAT(N)
	DO 18 J=1,V
	AVE(J)=SUM(J)/ND
18      CONTINUE
	WRITE (*,'(A)') ' MEANS ='
	WRITE (*,FMAT) (AVE(J),J=1,V)
C		    CALCULATE DEVIATIONS FROM THE MEAN
        DO 24 I=1,N
        DO 22 J=1,V
	X(I,J)=X(I,J)-AVE(J)
22      CONTINUE
24      CONTINUE
C
C                    CALCULATE SSCP (Z*Z')= U
        DO 32 J=1,V
        DO 30 K=1,V
        P=0.0
        DO 28 I=1,N 
	T=X(I,J)*X(I,K)
        P=P+T
28      CONTINUE
        U(J,K)=P
30      CONTINUE
32      CONTINUE
C
C		      CALCULATE S=SSCP/N
        DO 38 I=1,V
        DO 36 J=1,V
	DD=(1. / ND)
	S(I,J)=DD*U(I,J)
36      CONTINUE
38      CONTINUE
	WRITE (*,'(A)') ' S = (COVARIANCE MATRIX) '
        DO 40 I=1,V
	WRITE (*,FMAT) (S(I,J),J=1,I)
40      CONTINUE
C
C                       CALCULATE INVERSE OF S
C                        VIA LU DECOMPOSITION
        DO 48 I=1,V
        DO 46 J=1,V
         Y(I,J)=0.0
46      CONTINUE
         Y(I,I)=1.0
48      CONTINUE
	 CALL LUDCMP(S,V,NP,INDX,D)
        DO 50 J=1,V
	 CALL LUBSKB(S,V,NP,INDX,Y(1,J))
50	CONTINUE
C                      CALCULATE MARDIA'S B1 & B2
	CALL MB(Y,X,V,N,NP,B1,B2)
C                      CALCULATE MARDIA'S WB1 & WB2
	CALL WB(B1,B2,N,V,WB1,WB2)
C
C			CALCULATE K SQUARED --
C                       A TEST OF MULTIVARIATE 
C                          NON-NORMALITY
	K2=(WB1**2)+(WB2**2)
C
C		       ESTIMATE K2 SIGNIFICANCE BY CALLING
C		       INCOMPLETE GAMMA (CHI SQUARE) ROUTINES
	K2SIG=GAMMQ(1.,0.5*K2)
C
C		    TRANSFORM B1 AND OBTAIN CHI SQUARE
	  DF=(V/6.)*(V+1.)*(V+2.)
	  P1=(V+1.)*(ND+1.)*(ND+3.)
	  P2=ND*((ND+1.)*(V+1.)-6.)
	  CSQB1=((ND/6.)*B1)*(P1/P2)
	  BSIG=GAMMQ(0.5*DF,0.5*CSQB1)
C
C		    TRANSFORM B2 TO Z
	CALL B2Z(B2,V,ND,Z)
C
C	    TWO-TAILED SIGNIFICANCE TESTS FOR B2, WB1, WB2
	CALL NORM(Z,B2SIG)
	B2SIG=B2SIG*2.D0
	CALL NORM(WB1,WB1SIG)
	WB1SIG=WB1SIG*2.D0
	CALL NORM(WB2,WB2SIG)
	WB2SIG=WB2SIG*2.D0
C
C		       OUTPUT ROUTINE
	WRITE (*,400)	B1, CSQB1, DF, BSIG
	WRITE (*,405)	B2, Z, B2SIG
400	FORMAT (//,'     B1 = ',F7.4,'   CHI SQUARE = ',F6.2,
     &	'  DF = ', I3,'   P = ',F6.4)
405	FORMAT (/,'     B2 = ',F8.4,'  Z = ',F6.2,
     &	'     P = ',F6.4)
	WRITE (*,410) WB1, WB1SIG
410	FORMAT (/,'     WB1 = ',F7.3,'  P = ',F6.4,
     &	'     (MV SKEW)')
	WRITE (*,415) WB2, WB2SIG
415	FORMAT (/,'     WB2 = ',F7.3,'  P = ',F6.4,
     &	'     (MV KURTOSIS)')
	WRITE (*,420) K2, K2SIG
420	FORMAT (/,'     K  = ',F7.2, '  P = ',F6.4,
     &	'     (MV NON-NORMALITY)')
999	 END
C
C
	SUBROUTINE B2Z(B2,V,ND,Z)
	REAL*8 Z, T, B2P, B2, S, S1, ND
	INTEGER V
	B2P=V*(V+2)
	T=V*(V+2)*(ND-1.)/(ND+1.)
	S1=(8*V*(V+2))/ND
	S=DSQRT(S1)
	IF (B2 .GT. T) THEN
	  Z=(B2-B2P)/S
	 ELSE
	  Z=(B2-V*(V+2)*(ND+V+1.)/ND)/DSQRT(8*V*(V+2)/(ND-1.))
	 END IF
	 IF (ND .GT. 399.) THEN
	   Z=(B2-B2P)/S
	 END IF
	RETURN
	END
C
	SUBROUTINE NORM(Z,P)
C	    BASED ON ABRAMOWITZ AND STENGUN (1975)  26.2.17
	REAL*8 Z, Z1, P, SIGN, R, T, R1, B1, B2, B3, B4, B5,
     &	PI, RHO
	DATA R1 /.2316419/, B1 /.319381530/, B2 /-.356563782/,
     &	B3 /1.781477937/, B4 /-1.8212155978/,
     &	B5 /1.330274429/
C		ESTIMATE NORMAL DENSITY FUNCTION
	PI=(16.*DATAN(1./5.))-(4.*DATAN(1./239.))
	RHO=DSQRT(2.*PI)
	SIGN=Z/ABS(Z)
	Z=ABS(Z)
	Z1=(Z**2)/2
	R=DEXP(-Z1)/RHO
C		ESTIMATE CUMULATIVE PROBABILITY AREA
	T=1./(1.+(R1*Z))
	P=R*((B1*T)+(B2*T**2)+(B3*T**3)+(B4*T**4)+(B5*T**5))
	Z=Z*SIGN
	RETURN
	END
C
C
	SUBROUTINE LUDCMP(A,N,NP,INDX,D)
	REAL*8 A(NP,NP), TINY, AAMAX, SUM, P, T, VV
	DIMENSION INDX(N), VV(2000)
	NMAX=2000
        TINY=1.0E-20
        D=1.0
        DO 12 I=1,N
        AAMAX=0.0
         DO 11 J=1,N
          IF (ABS(A(I,J)) .GT. AAMAX) AAMAX=ABS(A(I,J))
11       CONTINUE
           IF (AAMAX .EQ. 0) PAUSE 'SINGULAR MATRIX'
          VV(I)=1.0/AAMAX
12      CONTINUE
        DO 19 J=1,N
         IF (J .GT. 1) THEN
           L=J-1
           DO 14 I=1,L
           SUM=A(I,J)
            IF (I .GT. 1) THEN
           T=I-1
          DO 13 K=1,T
         SUM=SUM-A(I,K)*A(K,J)
13      CONTINUE
         A(I,J)=SUM
        ENDIF
14      CONTINUE
        ENDIF
        AAMAX=0.0
        DO 16 I=J,N
         SUM=A(I,J)
          IF (J .GT. 1) THEN
          M=J-1
         DO 15 K=1,M
        SUM=SUM-A(I,K)*A(K,J)
15      CONTINUE
         A(I,J)=SUM
        ENDIF
         DUM=VV(I)*ABS(SUM)
          IF (DUM .GE. AAMAX) THEN
          IMAX=I
         AAMAX=DUM
        ENDIF
16      CONTINUE
        IF (J .NE. IMAX) THEN
        DO 17 K=1,N
         DUM=A(IMAX,K)
          A(IMAX,K)=A(J,K)
         A(J,K)=DUM
17      CONTINUE
        D=-D
         VV(IMAX)=VV(J)
        ENDIF
        INDX(J)=IMAX
        IF (J .NE. N) THEN
         IF (A(J,J) .EQ. 0) A(J,J)=TINY
          DUM=1.0/A(J,J)
          P=J+1
          DO 18 I=P,N
         A(I,J)=A(I,J)*DUM
18      CONTINUE
        ENDIF
19      CONTINUE
        IF (A(N,N) .EQ. 0) A(N,N)=TINY
        RETURN
        END
C
C
	SUBROUTINE LUBSKB(A,N,NP,INDX,B)
	REAL*8 A(NP,NP), B(N), SUM
	DIMENSION INDX(N)
        II=0
        DO 12 I=1,N
         LL=INDX(I)
          SUM=B(LL)
         B(LL)=B(I)
         I1=I-1
        IF (II .NE. 0) THEN
         DO 11 J=II,I1
          SUM=SUM-A(I,J)*B(J)
11      CONTINUE
         ELSE 
          IF (SUM .NE. 0) II=I
        ENDIF
        B(I)=SUM
12      CONTINUE
        DO 14 I=N,1,-1
         SUM=B(I)
          IF (I .LT. N) THEN
        M=I+1
        DO 13 J=M,N
          SUM=SUM-A(I,J)*B(J)
13      CONTINUE
        ENDIF
         B(I)=SUM/A(I,I)
14      CONTINUE
        RETURN
        END
C
	SUBROUTINE MB (SI,ZD,V,N,NP,B1,B2)
	INTEGER N,NP,L,V
	REAL*8 B1,B2
	REAL*8 QZ(2000,10), Q, BB, TX
	REAL*8 ZD(2000,10),SI(NP,NP)
	REAL*8 ZX(2000),ZY(2000),T,R
C
C               INITIALIZE
        DO 12 I=1,N
         DO 10 J=1,V
          QZ(I,J)=0.0
10      CONTINUE
12	CONTINUE
C
C               MULTIPLY H VECTORS * INVERSE OF SIGMA 
        DO 127 I=1,N
         DO 126 L=1,V
          DO 125 J=1,V
            Q=ZD(I,J)*SI(J,L)
                QZ(I,L)=QZ(I,L)+Q
125            CONTINUE
126           CONTINUE
127	    CONTINUE
	 WRITE (*,'(1X\)')
         DO 130 I=1,N
          ZY(I)=0.0
C               WRITE BUSY MARKS TO THE SCREEN
	    IF (0 .NE. MOD (I,10)) THEN
	     WRITE (*,'(A\)') '.'
              ELSE
	     WRITE (*,'(A\)') '+'
            ENDIF
C
C
	    DO 129 L=1,N
            TX=0.0
             DO 128 J=1,V
              T=QZ(I,J)*ZD(L,J)
             TX=TX+T
128         CONTINUE
	   ZY(I)=ZY(I)+(TX**3)
129      CONTINUE
130     CONTINUE
C		SUM ZY(I) TO OBTAIN B1 (SKEW)
C
        BB=0.0
        DO 138 I=1,N
	BB=BB+ZY(I)
138     CONTINUE
	B1=BB/(N**2)
C               CALCULATE B2
        DO 152 I=1,N
            R=0.0
                DO 146 L=1,V
             T=QZ(I,L)*ZD(I,L)
            R=R+T
146       CONTINUE
	 ZX(I)=R**2
152      CONTINUE
        BB=0.0
	DO 154 I=1,N
C	      SUM ZX(I) TO OBTAIN B2 (KURTOSIS)
	BB=BB+ZX(I)
154     CONTINUE
	B2=BB/N
	RETURN
        END
C
C
	SUBROUTINE WB(B1,B2,NN,VV,WB1,WB2)
	REAL*8 EB2,VB2,SB2,F1,N,V
	REAL*8 WB1, WB2, B1, B2, SIGN
	INTEGER VV
C
C		CONVERT INTEGERS TO REALS
	N=DFLOAT(NN)
	V=DFLOAT(VV)
C
C		CHECK FOR NEGATIVE VALUES OF B1
	SIGN=B1/ABS(B1)
	B1=ABS(B1)
C               CALCULATE WB1
	WB1=1/SQRT(12.D0*V*(V+1.D0)*(V+2.D0))*
     &	((27.D0*N*V**2*(V+1.D0)**2*(V+2.D0)**2*B1)**(1.D0/3.D0)
     &	-3.D0*V*(V+1.D0)*(V+2.D0)+4.D0)
C               RETURN INCOMING SIGN TO VALUES
	WB1=WB1*SIGN
	B1=B1*SIGN
C                CALCULATE WB2
	EB2=((N-1.D0)*V*(V+2.D0))/(N+1.D0)
	VB2=(8.D0*V*(V+2.D0))/N
        SB2=(B2-EB2)/SQRT(VB2)
	F1=6.D0+SQRT(8.D0*V*(V+2.D0)*(V+8.D0)**(-2))*
     &	SQRT(N)*(SQRT(0.5D0*V*(V+2.D0))
     &	*(V+8.D0)**(-1)*SQRT(N)+SQRT(1.D0+(0.5D0*V)
     &	*(V+2.D0)*(V+8.D0)**(-2)*N))
	WB2=3.D0*SQRT(F1/2.D0)*(1.D0-(2.D0/(9.D0*F1))-
     &	((1.D0-(2.D0/F1))/(1.D0+SB2*
     &	SQRT(2.D0/(F1-4.D0))))**(1.D0/3.D0))
	RETURN
	END
C
C               CHI SQUARE SIGNIFICANCE ROUTINES
C
	FUNCTION GAMMLN(XX)
	REAL*8 COF(6),STP,HALF,ONE,FPF,X,TMP,SER
        DATA COF /76.18009173,-86.50532033,24.01409822,
     *    -1.231739516, 0.120858003E-2,-0.536382E-5/
	DATA STP /2.50662827465/,HALF /0.5D0/,ONE /1.D0/,FPF /5.5D0/
        X=XX-ONE
        TMP=X+FPF
        TMP=(X+HALF)*ALOG(TMP)-TMP
        SER=ONE
        DO 11 L=1,6
            X=X+ONE
           SER=SER+COF(L)/X
11      CONTINUE
        GAMMLN=TMP+ALOG(STP*SER)
        RETURN
        END
C
C
	FUNCTION GAMMQ(A,X)
C		A=DF, X=CHSQ
	REAL*8 X
C	IF (X .LT. 0.0 .OR. A .LE. 0.0) PAUSE
        IF (X .LT. A+1.) THEN
         CALL GSER(GAMSER,A,X,GLN)
	 GAMMQ=(1.D0-GAMSER)+0.00001D0
        ELSE
         CALL GCF(GAMMQ,A,X,GLN)
	 GAMMQ=GAMMQ+0.00001D0
        ENDIF
        RETURN
        END
C
C
	SUBROUTINE GSER(GAMSER,A,X,GLN)
	REAL*8 AP, SUM, EPS, DEL, X
        ITMAX=100
        EPS=3.E-7
        GLN=GAMMLN(A)
        IF (X .LE. 0.) THEN
C	  IF (X .LT. 0.) PAUSE
          GAMSER=0.0
          RETURN
        ENDIF
        AP=A
        SUM=1./A
        DEL=SUM
        DO 11 L=1,ITMAX
                AP=AP+1.
                DEL=DEL*X/AP
                SUM=SUM+DEL
                IF (ABS(DEL) .LT. ABS(SUM)*EPS) GOTO 1
11      CONTINUE
        PAUSE 'IN GSER - A IS TOO LARGE, ITMAX TOO SMALL'
1       GAMSER=SUM*EXP(-X+A*ALOG(X)-GLN)
        RETURN
        END
C
C
	SUBROUTINE GCF(GAMMCF,A,X,GLN)
	REAL*8 EPS, GOLD, A0, A1, B0, B1, FAC, X
	REAL*8 ANF,ANA,G
        ITMAX=300
        EPS=3.E-7
        GLN=GAMMLN(A)
        GOLD=0.
        A0=1.
        A1=X
        B0=0.
        B1=1.
        FAC=1.
        DO 11 L=1,ITMAX
           AN=FLOAT(L)
           ANA=AN-A
           A0=(A1+A0*ANA)*FAC
           B0=(B1+B0*ANA)*FAC
           ANF=AN*FAC
           A1=X*A0+ANF*A1
           B1=X*B0+ANF*B1
        IF (A1 .NE. 0.) THEN
           FAC=1./A1
           G=B1*FAC
           IF(ABS((G-GOLD)/G).LT.EPS) GOTO 1
           GOLD=G
        ENDIF
11      CONTINUE
        PAUSE 'IN GCF - A IS TOO LARGE, ITMAX IS TOO SMALL'
1       GAMMCF=EXP(-X+A*ALOG(X)-GLN)*G
        RETURN
        END
